/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.tests.encoding;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class HTMLEncodingTestsPlugin
extends Plugin {
    private static HTMLEncodingTestsPlugin plugin;

    public static List getAllTestFiles(String topDirName) {
        List result = null;
        URL installURL = HTMLEncodingTestsPlugin.getInstallLocation();
        String path = installURL.getPath();
        String location = String.valueOf(path) + topDirName;
        File topDir = new File(location);
        if (!topDir.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(topDirName) + " is not a directory");
        }
        result = HTMLEncodingTestsPlugin.getFilesInDir(topDir);
        return result;
    }

    public static HTMLEncodingTestsPlugin getDefault() {
        return plugin;
    }

    private static List getFilesInDir(File topDir) {
        ArrayList<File> files = new ArrayList<File>();
        File[] topFiles = topDir.listFiles();
        int i = 0;
        while (i < topFiles.length) {
            File file = topFiles[i];
            if (file.isFile()) {
                files.add(file);
            } else if (file.isDirectory() && !file.getName().endsWith("CVS")) {
                List innerFiles = HTMLEncodingTestsPlugin.getFilesInDir(file);
                files.addAll(innerFiles);
            }
            ++i;
        }
        return files;
    }

    public static URL getInstallLocation() {
        URL installLocation = Platform.getBundle((String)"org.eclipse.wst.html.tests.encoding").getEntry("/");
        URL resolvedLocation = null;
        try {
            resolvedLocation = FileLocator.resolve((URL)installLocation);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return resolvedLocation;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = HTMLEncodingTestsPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static File getTestFile(String filepath) {
        URL installURL = HTMLEncodingTestsPlugin.getInstallLocation();
        String path = installURL.getPath();
        String location = String.valueOf(path) + filepath;
        File result = new File(location);
        return result;
    }

    public static Reader getTestReader(String filepath) throws FileNotFoundException {
        URL installURL = HTMLEncodingTestsPlugin.getInstallLocation();
        String path = installURL.getPath();
        String location = String.valueOf(path) + filepath;
        FileReader result = new FileReader(location);
        return result;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public HTMLEncodingTestsPlugin() {
        plugin = this;
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }
}

