/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.resources;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import junit.framework.Assert;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsf.common.internal.resource.ContentTypeResolver;
import org.eclipse.jst.jsf.common.internal.util.JarUtilities;
import org.eclipse.jst.jsf.designtime.internal.resources.JarBasedJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifierFactory;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsf.test.util.mock.MockContentTypeManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NoPluginEnvironment.class})
public class TestJarBasedJSFResource {
    private JarFile _jarFile;
    private ZipEntry _entry;
    private ContentTypeResolver _contentTypeResolver;

    @Before
    public void setUp() throws IOException {
        File file = new File("./testdata/jsfResources.jar");
        Assert.assertTrue((boolean)file.exists());
        this._jarFile = new JarFile(file.getAbsoluteFile());
        this._entry = this._jarFile.getEntry("META-INF/resources/mylib/tag1.xhtml");
        Assert.assertNotNull((Object)this._entry);
        this._contentTypeResolver = new ContentTypeResolver((IContentTypeManager)new MockContentTypeManager());
    }

    @Test
    public void testJarBasedJSFResource() throws MalformedURLException, ResourceIdentifierFactory.InvalidIdentifierException {
        URL url = JarUtilities.INSTANCE.createJarUrl(this._jarFile, (JarEntry)this._entry);
        ResourceIdentifier id = new ResourceIdentifierFactory().createLibraryResource("mylib/tag1.xhtml");
        JarBasedJSFResource resource = new JarBasedJSFResource(id, url, this._contentTypeResolver);
        Assert.assertSame((Object)id, (Object)resource.getId());
        Assert.assertSame((Object)url, (Object)resource.getJarURL());
        Assert.assertTrue((boolean)resource.isAccessible());
    }

    @Test
    public void testJarBasedJSFResource_BadUrl() throws MalformedURLException, ResourceIdentifierFactory.InvalidIdentifierException {
        URL url = JarUtilities.INSTANCE.createJarUrl("/SomeBadPath", "");
        ResourceIdentifier id = new ResourceIdentifierFactory().createLibraryResource("mylib/tag1.xhtml");
        JarBasedJSFResource resource = new JarBasedJSFResource(id, url, this._contentTypeResolver);
        Assert.assertSame((Object)id, (Object)resource.getId());
        Assert.assertSame((Object)url, (Object)resource.getJarURL());
        Assert.assertFalse((boolean)resource.isAccessible());
    }

    @Test
    public void testJarBasedJSFResource_GoodUrlBadEntry() throws MalformedURLException, ResourceIdentifierFactory.InvalidIdentifierException {
        URL url = JarUtilities.INSTANCE.createJarUrl(this._jarFile, (JarEntry)this._entry);
        ResourceIdentifier id = new ResourceIdentifierFactory().createLibraryResource("mylib/notATag1.xhtml");
        JarBasedJSFResource resource = new JarBasedJSFResource(id, url, this._contentTypeResolver);
        Assert.assertSame((Object)id, (Object)resource.getId());
        Assert.assertSame((Object)url, (Object)resource.getJarURL());
        Assert.assertFalse((boolean)resource.isAccessible());
    }

    @Test
    public void testJarEntryURL() throws IOException, URISyntaxException {
        URL url = JarUtilities.INSTANCE.createJarUrl(this._jarFile, (JarEntry)this._entry);
        Assert.assertNotNull((Object)url);
        URLConnection jarConnection = url.openConnection();
        Assert.assertTrue((boolean)(jarConnection instanceof JarURLConnection));
        JarEntry jarEntry = ((JarURLConnection)jarConnection).getJarEntry();
        Assert.assertNotNull((Object)jarEntry);
        Assert.assertEquals((String)this._entry.getName(), (String)jarEntry.getName());
        Assert.assertEquals((boolean)this._entry.isDirectory(), (boolean)jarEntry.isDirectory());
    }
}

