/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.invoker.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(record.getMillis()), ZoneId.systemDefault());
        try (java.util.Formatter formatter = new java.util.Formatter(builder);){
            formatter.format("%1$tT,%1$tL %2$-7s [%3$s] ", zdt, record.getLevel().getLocalizedName(), record.getThreadID());
            String loggerName = record.getLoggerName();
            int lastDot = loggerName.lastIndexOf(46);
            if (lastDot < 0) {
                builder.append(loggerName);
            } else if (lastDot == loggerName.length() - 1) {
                int secondLastDot = loggerName.lastIndexOf(46, lastDot - 1);
                if (secondLastDot < 0) {
                    builder.append(loggerName, secondLastDot + 1, loggerName.length());
                } else {
                    builder.append(loggerName);
                }
            } else {
                builder.append(loggerName, lastDot + 1, loggerName.length());
            }
            builder.append(" - ");
            builder.append(record.getMessage());
            String throwable = "";
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            formatter.format("%s%n", throwable);
            String string = builder.toString();
            return string;
        }
    }
}

