/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class BP4105
extends AssertionProcess {
    private static final String GZIP_VALUE = "gzip";
    private static final String COMPRESS_VALUE = "compress";
    private static final String DEFLATE_VALUE = "deflate";
    private final BaseMessageValidator validator;

    public BP4105(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String contentEncoding = (String)HTTPUtils.getHttpHeaderTokens(entryContext.getMessageEntry().getHTTPHeaders(), ":").get("Content-Encoding".toUpperCase());
        if (contentEncoding != null) {
            contentEncoding = contentEncoding.toLowerCase();
            StringTokenizer st = new StringTokenizer(contentEncoding, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.equals(GZIP_VALUE) || token.equals(COMPRESS_VALUE) || token.equals(DEFLATE_VALUE)) continue;
                this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
                break;
            }
        }
        if (this.failureDetail == null) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

