/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.state;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.IPropertyState;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.state.PropertyStateAdapterFactory;

public class SeiPropertyStateAdapterTest
extends TestCase {
    private IServiceEndpointInterface sei;
    private IWebService ws;

    public void setUp() {
        this.sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        this.ws = DomFactory.eINSTANCE.createIWebService();
        this.sei.getImplementingWebServices().add((Object)this.ws);
    }

    public void testIsAdapted() {
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.sei, IPropertyState.class);
        SeiPropertyStateAdapterTest.assertNotNull((Object)adapter);
    }

    public void testIsChangeableOutsideIn() {
        this.ws.setWsdlLocation("C:/test");
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.sei, IPropertyState.class);
        SeiPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        SeiPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.ISERVICE_ENDPOINT_INTERFACE__IMPLICIT));
        SeiPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.ISERVICE_ENDPOINT_INTERFACE__TARGET_NAMESPACE));
    }

    public void testIsChangealbeInOutImplicitInterface() {
        this.sei.eSet((EStructuralFeature)DomPackage.Literals.ISERVICE_ENDPOINT_INTERFACE__IMPLICIT, (Object)Boolean.TRUE);
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.sei, IPropertyState.class);
        SeiPropertyStateAdapterTest.assertTrue((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        SeiPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.ISERVICE_ENDPOINT_INTERFACE__IMPLICIT));
        SeiPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.ISERVICE_ENDPOINT_INTERFACE__TARGET_NAMESPACE));
    }

    public void testIsChangeableInOutExplicitInterface() {
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.sei, IPropertyState.class);
        SeiPropertyStateAdapterTest.assertTrue((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        SeiPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.ISERVICE_ENDPOINT_INTERFACE__IMPLICIT));
        SeiPropertyStateAdapterTest.assertTrue((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.ISERVICE_ENDPOINT_INTERFACE__TARGET_NAMESPACE));
    }
}

