/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.value.CompositePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class CompositePropertyValueModelTests
extends TestCase {
    private SimplePropertyValueModel<Integer> pvm1;
    private ModifiablePropertyValueModel<Integer> pvm2;
    private ModifiablePropertyValueModel<Integer> pvm3;
    private ModifiablePropertyValueModel<Integer> pvm4;
    private Collection<ModifiablePropertyValueModel<Integer>> collection;
    private SimpleCollectionValueModel<ModifiablePropertyValueModel<Integer>> cvm;
    private PropertyValueModel<Integer> compositePVM;
    PropertyChangeEvent event;

    public CompositePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.pvm1 = new SimplePropertyValueModel((Object)1);
        this.pvm2 = new SimplePropertyValueModel((Object)2);
        this.pvm3 = new SimplePropertyValueModel((Object)3);
        this.pvm4 = new SimplePropertyValueModel((Object)4);
        this.collection = new ArrayList<ModifiablePropertyValueModel<Integer>>();
        this.collection.add((ModifiablePropertyValueModel<Integer>)this.pvm1);
        this.collection.add(this.pvm2);
        this.collection.add(this.pvm3);
        this.collection.add(this.pvm4);
        this.cvm = new SimpleCollectionValueModel(this.collection);
        this.compositePVM = this.buildCompositePVM((CollectionValueModel)this.cvm);
    }

    private <T extends PropertyValueModel<Integer>> PropertyValueModel<Integer> buildCompositePVM(CollectionValueModel<T> pvms) {
        return new CompositePropertyValueModel<Integer, Integer>(pvms){

            protected Integer buildValue() {
                int sum = 0;
                for (PropertyValueModel each : this.collectionModel) {
                    sum += ((Integer)each.getValue()).intValue();
                }
                return sum;
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetValue() {
        CompositePropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
        ChangeListener listener = this.buildListener();
        this.compositePVM.addChangeListener(listener);
        CompositePropertyValueModelTests.assertEquals((int)10, (int)((Integer)this.compositePVM.getValue()));
    }

    public void testValueAndListeners1() {
        CompositePropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
        ChangeListener listener = this.buildListener();
        this.compositePVM.addChangeListener(listener);
        CompositePropertyValueModelTests.assertEquals((int)10, (int)((Integer)this.compositePVM.getValue()));
        this.compositePVM.removeChangeListener(listener);
        CompositePropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
    }

    public void testValueAndListeners2() {
        CompositePropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
        ChangeListener listener = this.buildListener();
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositePropertyValueModelTests.assertEquals((int)10, (int)((Integer)this.compositePVM.getValue()));
        this.compositePVM.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositePropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
    }

    public void testPropertyChange1() {
        this.compositePVM.addChangeListener(this.buildListener());
        this.verifyPropertyChange();
    }

    public void testPropertyChange2() {
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.verifyPropertyChange();
    }

    private void verifyPropertyChange() {
        this.event = null;
        this.pvm1.setValue((Object)5);
        this.verifyEvent(10, 14);
        this.event = null;
        this.pvm4.setValue((Object)0);
        this.verifyEvent(14, 10);
    }

    public void testCollectionChange1() {
        this.compositePVM.addChangeListener(this.buildListener());
        this.verifyCollectionChange();
    }

    public void testCollectionChange2() {
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.verifyCollectionChange();
    }

    private void verifyCollectionChange() {
        this.event = null;
        SimplePropertyValueModel pvm = new SimplePropertyValueModel((Object)77);
        this.cvm.add((Object)pvm);
        this.verifyEvent(10, 87);
        this.event = null;
        this.cvm.remove((Object)pvm);
        this.verifyEvent(87, 10);
        this.event = null;
        this.cvm.clear();
        this.verifyEvent(10, 0);
        ArrayList<Object> c2 = new ArrayList<Object>();
        c2.add(this.pvm1);
        c2.add(this.pvm2);
        this.event = null;
        this.cvm.setValues(c2);
        this.verifyEvent(0, 3);
    }

    public void testLazyListening1() {
        CompositePropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        ChangeListener listener = this.buildListener();
        this.compositePVM.addChangeListener(listener);
        CompositePropertyValueModelTests.assertTrue((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        this.compositePVM.removeChangeListener(listener);
        CompositePropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
    }

    public void testLazyListening2() {
        CompositePropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        ChangeListener listener = this.buildListener();
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositePropertyValueModelTests.assertTrue((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        this.compositePVM.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositePropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                CompositePropertyValueModelTests.this.event = e;
            }
        };
    }

    private void verifyEvent(int oldValue, int newValue) {
        CompositePropertyValueModelTests.assertEquals(this.compositePVM, (Object)this.event.getSource());
        CompositePropertyValueModelTests.assertEquals((String)"value", (String)this.event.getPropertyName());
        CompositePropertyValueModelTests.assertEquals((Object)oldValue, (Object)this.event.getOldValue());
        CompositePropertyValueModelTests.assertEquals((Object)newValue, (Object)this.event.getNewValue());
    }
}

