/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.internal.reference.SimpleIntReference;
import org.eclipse.jpt.common.utility.reference.ModifiableIntReference;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.reference.ModifiableIntReferenceTests;

public class SimpleIntReferenceTests
extends ModifiableIntReferenceTests {
    public SimpleIntReferenceTests(String name) {
        super(name);
    }

    @Override
    protected ModifiableIntReference buildIntReference(int value) {
        return new SimpleIntReference(value);
    }

    public void testCtors() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertEquals((int)7, (int)ir.getValue());
        ir = new SimpleIntReference(-7);
        SimpleIntReferenceTests.assertEquals((int)-7, (int)ir.getValue());
    }

    public void testClone() {
        SimpleIntReference ir1 = new SimpleIntReference(44);
        SimpleIntReference ir2 = ir1.clone();
        SimpleIntReferenceTests.assertEquals((int)44, (int)ir2.getValue());
        SimpleIntReferenceTests.assertNotSame((Object)ir1, (Object)ir2);
    }

    public void testSerialization() throws Exception {
        SimpleIntReference ir1 = new SimpleIntReference(44);
        SimpleIntReference ir2 = TestTools.serialize(ir1);
        SimpleIntReferenceTests.assertEquals((int)44, (int)ir2.getValue());
        SimpleIntReferenceTests.assertNotSame((Object)ir1, (Object)ir2);
    }
}

