/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class InstanceOfTests
extends TestCase {
    private Predicate<Number> instanceOfPredicate;

    public InstanceOfTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.instanceOfPredicate = PredicateTools.instanceOf(Number.class);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        Predicate instanceOfPredicate2 = PredicateTools.instanceOf(Integer.class);
        InstanceOfTests.assertTrue((boolean)this.instanceOfPredicate.evaluate((Object)new Integer(42)));
        InstanceOfTests.assertTrue((boolean)instanceOfPredicate2.evaluate((Object)new Integer(42)));
        InstanceOfTests.assertTrue((boolean)this.instanceOfPredicate.evaluate((Object)42));
        InstanceOfTests.assertTrue((boolean)instanceOfPredicate2.evaluate((Object)42));
        InstanceOfTests.assertTrue((boolean)this.instanceOfPredicate.evaluate((Object)Integer.valueOf("42")));
        InstanceOfTests.assertTrue((boolean)instanceOfPredicate2.evaluate((Object)Integer.valueOf("42")));
        InstanceOfTests.assertFalse((boolean)this.instanceOfPredicate.evaluate(null));
        InstanceOfTests.assertFalse((boolean)instanceOfPredicate2.evaluate(null));
        InstanceOfTests.assertTrue((boolean)this.instanceOfPredicate.evaluate((Object)24));
        InstanceOfTests.assertTrue((boolean)instanceOfPredicate2.evaluate((Object)24));
        InstanceOfTests.assertTrue((boolean)this.instanceOfPredicate.evaluate((Object)Float.valueOf(24.0f)));
        InstanceOfTests.assertFalse((boolean)instanceOfPredicate2.evaluate((Object)Float.valueOf(24.0f)));
    }

    public void testEquals() {
        Predicate instanceOfPredicate2 = PredicateTools.instanceOf(Number.class);
        InstanceOfTests.assertEquals(this.instanceOfPredicate, (Object)instanceOfPredicate2);
        InstanceOfTests.assertEquals((int)this.instanceOfPredicate.hashCode(), (int)instanceOfPredicate2.hashCode());
        InstanceOfTests.assertFalse((boolean)this.instanceOfPredicate.equals((Object)IsNotNull.instance()));
    }
}

