/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.eol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.tests.internal.eol.CheckWinEOL;

public class CheckWinEOLTests
extends TestCase {
    public CheckWinEOLTests(String name) {
        super(name);
    }

    public void testStreamHasInvalidWinEOL() throws IOException {
        byte CR = 13;
        byte LF = 10;
        this.verifyInvalidWinEOL(new byte[]{CR});
        this.verifyInvalidWinEOL(new byte[]{LF});
        this.verifyInvalidWinEOL(new byte[]{LF, CR});
        this.verifyInvalidWinEOL(new byte[]{CR, CR, LF});
        this.verifyInvalidWinEOL(new byte[]{CR, LF, LF});
        this.verifyInvalidWinEOL(new byte[]{CR, LF, CR});
        this.verifyValidWinEOL(new byte[0]);
        this.verifyValidWinEOL(new byte[]{CR, LF});
        this.verifyValidWinEOL(new byte[]{CR, LF, CR, LF});
        this.verifyValidWinEOL(new byte[]{CR, LF, 97, CR, LF});
    }

    private void verifyInvalidWinEOL(byte[] bytes) throws IOException {
        CheckWinEOLTests.assertTrue((boolean)CheckWinEOL.streamHasInvalidWinEOL(this.buildInputStream(bytes)));
    }

    private void verifyValidWinEOL(byte[] bytes) throws IOException {
        CheckWinEOLTests.assertFalse((boolean)CheckWinEOL.streamHasInvalidWinEOL(this.buildInputStream(bytes)));
    }

    private InputStream buildInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }
}

