/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.XMLTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLToolsReadTests
extends TestCase {
    private Document testDocument;
    private Node rootNode;

    public XMLToolsReadTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testDocument = this.buildTestDocument();
        this.rootNode = XMLTools.getChild((Node)this.testDocument, (String)"root-element");
    }

    private Document buildTestDocument() {
        return XMLTools.parse((Reader)new StringReader(this.buildTestDocumentString()));
    }

    private String buildTestDocumentString() {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("<?xml version = '1.0' encoding = 'UTF-8'?>");
        sb.append("<root-element>");
        sb.append("<element-0>");
        sb.append("<element-0-text-1>some text</element-0-text-1>");
        sb.append("<element-0-text-2></element-0-text-2>");
        sb.append("<element-0-text-3/>");
        sb.append("<element-0-non-text>");
        sb.append("<element-0-non-text-child>");
        sb.append("</element-0-non-text-child>");
        sb.append("</element-0-non-text>");
        sb.append("</element-0>");
        sb.append("<element-1>");
        sb.append("<element-1-int>42</element-1-int>");
        sb.append("<element-1-boolean-true-1>true</element-1-boolean-true-1>");
        sb.append("<element-1-boolean-true-2>T</element-1-boolean-true-2>");
        sb.append("<element-1-boolean-true-3>1</element-1-boolean-true-3>");
        sb.append("<element-1-boolean-false-1>false</element-1-boolean-false-1>");
        sb.append("<element-1-boolean-false-2>F</element-1-boolean-false-2>");
        sb.append("<element-1-boolean-false-3>0</element-1-boolean-false-3>");
        sb.append("</element-1>");
        sb.append("<element-2>");
        sb.append("<element-2.0>");
        sb.append("</element-2.0>");
        sb.append("<element-2.0>");
        sb.append("</element-2.0>");
        sb.append("<element-2.0>");
        sb.append("</element-2.0>");
        sb.append("</element-2>");
        sb.append("<element-3>element 3 contents</element-3>");
        sb.append("</root-element>");
        return sb.toString();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetChild() {
        XMLToolsReadTests.assertEquals((String)"element-1", (String)XMLTools.getChild((Node)this.rootNode, (String)"element-1").getNodeName());
        XMLToolsReadTests.assertEquals((String)"element-3", (String)XMLTools.getChild((Node)this.rootNode, (String)"element-3").getNodeName());
        XMLToolsReadTests.assertEquals(null, (Object)XMLTools.getChild((Node)this.rootNode, (String)"element-1x"));
    }

    public void testGetChildren() {
        Iterable children = XMLTools.getChildren((Node)this.rootNode);
        XMLToolsReadTests.assertEquals((int)4, (int)IterableTools.size((Iterable)children));
        int i = 1;
        while (i < 4) {
            XMLToolsReadTests.assertEquals((String)("element-" + i), (String)((Node)IterableTools.get((Iterable)children, (int)i)).getNodeName());
            ++i;
        }
    }

    public void testGetChildrenNamed() {
        Node element2Node = XMLTools.getChild((Node)this.rootNode, (String)"element-2");
        Iterable children = XMLTools.getChildren((Node)element2Node, (String)"element-2.0");
        XMLToolsReadTests.assertEquals((int)3, (int)IterableTools.size((Iterable)children));
        int i = 0;
        while (i < 3) {
            XMLToolsReadTests.assertEquals((String)"element-2.0", (String)((Node)IterableTools.get((Iterable)children, (int)i)).getNodeName());
            ++i;
        }
    }

    public void testGetTextContent() {
        Node node = XMLTools.getChild((Node)this.rootNode, (String)"element-0");
        Node childNode = XMLTools.getChild((Node)node, (String)"element-0-text-1");
        XMLToolsReadTests.assertEquals((String)"some text", (String)XMLTools.getTextContent((Node)childNode));
        childNode = XMLTools.getChild((Node)node, (String)"element-0-text-2");
        XMLToolsReadTests.assertEquals((String)"", (String)XMLTools.getTextContent((Node)childNode));
        childNode = XMLTools.getChild((Node)node, (String)"element-0-text-3");
        XMLToolsReadTests.assertEquals((String)"", (String)XMLTools.getTextContent((Node)childNode));
        childNode = XMLTools.getChild((Node)node, (String)"element-0-non-text");
        boolean exCaught = false;
        try {
            String text = XMLTools.getTextContent((Node)childNode);
            text = text.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        XMLToolsReadTests.assertTrue((boolean)exCaught);
    }

    public void testGetChildTextContent() {
        XMLToolsReadTests.assertEquals((String)"element 3 contents", (String)XMLTools.getChildTextContent((Node)this.rootNode, (String)"element-3"));
    }

    public void testGetChildTextContentDefaultValue() {
        XMLToolsReadTests.assertEquals((String)"element 3 contents", (String)XMLTools.getChildTextContent((Node)this.rootNode, (String)"element-3", (String)"default value 3"));
        XMLToolsReadTests.assertEquals((String)"default value 4", (String)XMLTools.getChildTextContent((Node)this.rootNode, (String)"element-4", (String)"default value 4"));
    }

    public void testGetChildIntContent() {
        Node node = XMLTools.getChild((Node)this.rootNode, (String)"element-1");
        XMLToolsReadTests.assertEquals((int)42, (int)XMLTools.getChildIntContent((Node)node, (String)"element-1-int"));
    }

    public void testGetChildIntContentDefaultValue() {
        Node node = XMLTools.getChild((Node)this.rootNode, (String)"element-1");
        XMLToolsReadTests.assertEquals((int)42, (int)XMLTools.childIntContent((Node)node, (String)"element-1-int", (int)99));
        XMLToolsReadTests.assertEquals((int)99, (int)XMLTools.childIntContent((Node)node, (String)"element-1-int-x", (int)99));
    }

    public void testGetChildBooleanContent() {
        Node node = XMLTools.getChild((Node)this.rootNode, (String)"element-1");
        XMLToolsReadTests.assertTrue((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-true-1"));
        XMLToolsReadTests.assertTrue((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-true-2"));
        XMLToolsReadTests.assertTrue((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-true-3"));
        XMLToolsReadTests.assertFalse((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-false-1"));
        XMLToolsReadTests.assertFalse((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-false-2"));
        XMLToolsReadTests.assertFalse((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-false-3"));
    }

    public void testGetChildBooleanContentDefaultValue() {
        Node node = XMLTools.getChild((Node)this.rootNode, (String)"element-1");
        XMLToolsReadTests.assertTrue((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-true-1", (boolean)false));
        XMLToolsReadTests.assertTrue((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-true-2", (boolean)false));
        XMLToolsReadTests.assertTrue((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-true-3", (boolean)false));
        XMLToolsReadTests.assertFalse((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-true-bogus", (boolean)false));
        XMLToolsReadTests.assertFalse((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-false-1", (boolean)true));
        XMLToolsReadTests.assertFalse((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-false-2", (boolean)true));
        XMLToolsReadTests.assertFalse((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-false-3", (boolean)true));
        XMLToolsReadTests.assertTrue((boolean)XMLTools.getChildBooleanContent((Node)node, (String)"element-1-boolean-false-bogus", (boolean)true));
    }
}

