/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.coap.client.templates;

import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.coap.CoAPUtils;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CoAPClientPropertyTemplate
implements ITemplate<Property> {
    private String primTypeSuffix;
    private String paramSetSuffx;

    public CoAPClientPropertyTemplate(String primTypeSuffix, String paramSetSuffx) {
        this.primTypeSuffix = primTypeSuffix;
        this.paramSetSuffx = paramSetSuffx;
    }

    public String getContent(Property property, InvocationContext invocationContext) {
        boolean _isWritable;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* ");
        String _description = property.getDescription();
        _builder.append((Object)_description, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        boolean _isReadable = Utils.isReadable((Property)property);
        if (_isReadable) {
            PropertyType _type = property.getType();
            if (_type instanceof ObjectPropertyType) {
                _builder.append((Object)"public ");
                String _propertyTypeAsString = CoAPUtils.getPropertyTypeAsString(property);
                _builder.append((Object)_propertyTypeAsString, "");
                _builder.append((Object)" get");
                String _name = property.getName();
                String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                _builder.append((Object)_firstUpper, "");
                _builder.append((Object)"(){");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"public ");
                String _propertyTypeAsString_1 = CoAPUtils.getPropertyTypeAsString(property);
                _builder.append((Object)_propertyTypeAsString_1, "");
                _builder.append((Object)" get");
                String _name_1 = property.getName();
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
                _builder.append((Object)_firstUpper_1, "");
                _builder.append((Object)"() throws Exception {");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"final Response response = Client.sendRequest(BASE_URI + \"/\" + \"");
            String _name_2 = property.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name_2);
            _builder.append((Object)_firstLower, "\t");
            _builder.append((Object)"\", CoapMethod.GET);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if(Client.isValidResponseWithPayload(response)) {");
            _builder.newLine();
            PropertyType _type_1 = property.getType();
            if (_type_1 instanceof ObjectPropertyType) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"final Object o = Client.deserializePayload(");
                String _propertyTypeAsString_2 = CoAPUtils.getPropertyTypeAsString(property);
                _builder.append((Object)_propertyTypeAsString_2, "\t\t");
                _builder.append((Object)".class, response.getPayload());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if(o instanceof ");
                String _propertyTypeAsString_3 = CoAPUtils.getPropertyTypeAsString(property);
                _builder.append((Object)_propertyTypeAsString_3, "\t\t");
                _builder.append((Object)"){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return (");
                String _propertyTypeAsString_4 = CoAPUtils.getPropertyTypeAsString(property);
                _builder.append((Object)_propertyTypeAsString_4, "\t\t\t");
                _builder.append((Object)") o;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"final Object o = Client.deserializePayload(");
                String _name_3 = property.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                _builder.append((Object)_firstUpper_2, "\t\t");
                _builder.append((Object)this.primTypeSuffix, "\t\t");
                _builder.append((Object)".class, response.getPayload());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if(o instanceof ");
                String _name_4 = property.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
                _builder.append((Object)_firstUpper_3, "\t\t");
                _builder.append((Object)this.primTypeSuffix, "\t\t");
                _builder.append((Object)"){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"final ");
                String _name_5 = property.getName();
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_5);
                _builder.append((Object)_firstUpper_4, "\t\t\t");
                _builder.append((Object)this.primTypeSuffix, "\t\t\t");
                _builder.append((Object)" result = (");
                String _name_6 = property.getName();
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_6);
                _builder.append((Object)_firstUpper_5, "\t\t\t");
                _builder.append((Object)this.primTypeSuffix, "\t\t\t");
                _builder.append((Object)") o;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return result.getValue();");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            PropertyType _type_2 = property.getType();
            if (_type_2 instanceof ObjectPropertyType) {
                _builder.append((Object)"\t");
                _builder.append((Object)"return null;");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"throw new Exception(\"Request Failed!\");");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        if (_isWritable = Utils.isWritable((Property)property)) {
            _builder.newLine();
            _builder.append((Object)"public void set");
            String _name_7 = property.getName();
            String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_7);
            _builder.append((Object)_firstUpper_6, "");
            _builder.append((Object)"(");
            String _propertyTypeAsString_5 = CoAPUtils.getPropertyTypeAsString(property);
            _builder.append((Object)_propertyTypeAsString_5, "");
            _builder.append((Object)" ");
            String _name_8 = property.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_8);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            PropertyType _type_3 = property.getType();
            if (_type_3 instanceof PrimitivePropertyType) {
                _builder.append((Object)"\t");
                String _name_9 = property.getName();
                String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_9);
                _builder.append((Object)_firstUpper_7, "\t");
                _builder.append((Object)this.paramSetSuffx, "\t");
                _builder.append((Object)" paramSet = new ");
                String _name_10 = property.getName();
                String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_10);
                _builder.append((Object)_firstUpper_8, "\t");
                _builder.append((Object)this.paramSetSuffx, "\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"paramSet.setValue(");
                String _name_11 = property.getName();
                String _firstLower_2 = StringExtensions.toFirstLower((String)_name_11);
                _builder.append((Object)_firstLower_2, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"byte[] payload = Client.serializePayload(paramSet);");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"byte[] payload = Client.serializePayload(");
                String _name_12 = property.getName();
                String _firstLower_3 = StringExtensions.toFirstLower((String)_name_12);
                _builder.append((Object)_firstLower_3, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"Client.sendRequest(BASE_URI + \"/\" + \"");
            String _name_13 = property.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_13);
            _builder.append((Object)_firstLower_4, "\t");
            _builder.append((Object)"\", CoapMethod.PUT, payload);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        return _builder.toString();
    }
}

