/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.help;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.virgo.shell.internal.help.HelpAccessor;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileHelpAccessor
implements HelpAccessor {
    private static final char HELP_FILE_COMMENT_CHARACTER = '#';
    private static final String HELP_ACCESSOR_RESOURCE_EXTENSION = ".help";
    private static final Logger logger = LoggerFactory.getLogger(SimpleFileHelpAccessor.class);

    @Override
    public List<String> getDetailedHelp(Class<?> clazz) {
        block12: {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader readFileIn = this.helpResourceReader(clazz);){
                    if (readFileIn == null) break block12;
                    return this.readAllButFirstHelpLines(readFileIn);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                logger.error(String.format("Exception reading help resource for class '%s'.", clazz.getCanonicalName()), (Throwable)ioe);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getSummaryHelp(Class<?> clazz) {
        block12: {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader readFileIn = this.helpResourceReader(clazz);){
                    if (readFileIn == null) break block12;
                    return this.readFirstHelpLine(readFileIn);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                logger.error(String.format("Exception reading help resource for class '%s'.", clazz.getCanonicalName()), (Throwable)ioe);
            }
        }
        return null;
    }

    private final String readFirstHelpLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (SimpleFileHelpAccessor.contentLine(line)) {
                return line;
            }
            line = reader.readLine();
        }
        return line;
    }

    private final List<String> readAllButFirstHelpLines(BufferedReader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = reader.readLine();
        boolean skipLine = true;
        while (line != null) {
            if (SimpleFileHelpAccessor.contentLine(line)) {
                if (!skipLine) {
                    lines.add(line);
                } else {
                    skipLine = false;
                }
            }
            line = reader.readLine();
        }
        return lines;
    }

    private static final boolean contentLine(String line) {
        if (line == null) {
            return false;
        }
        return line.length() == 0 || line.charAt(0) != '#';
    }

    private final BufferedReader helpResourceReader(Class<?> clazz) {
        String fileResourceName;
        URL resourceUrl;
        BufferedReader readFileIn = null;
        String className = clazz.getCanonicalName();
        if (className != null && (resourceUrl = this.helpResourceUrl(clazz, fileResourceName = new StringBuffer(className).append(HELP_ACCESSOR_RESOURCE_EXTENSION).toString())) != null) {
            InputStream resourceIn = null;
            try {
                resourceIn = resourceUrl.openStream();
                readFileIn = new BufferedReader(new InputStreamReader(resourceIn, StandardCharsets.UTF_8));
            }
            catch (IOException ioe) {
                logger.error(String.format("Exception reading help resource '%s'.", resourceUrl), (Throwable)ioe);
                IOUtils.closeQuietly((Closeable)resourceIn);
                return null;
            }
        }
        return readFileIn;
    }

    protected URL helpResourceUrl(Class<?> clazz, String fileResourceName) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        try {
            if (bundle != null) {
                return bundle.getResource(fileResourceName);
            }
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Exception obtaining help resource file '%s'.", fileResourceName), (Throwable)ise);
        }
        return null;
    }
}

