/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.common;

import java.util.Enumeration;
import java.util.Iterator;

public class IterableEnumeration<T>
implements Iterable<T> {
    private final Iterator<T> iterator;

    public IterableEnumeration(Enumeration<T> enumeration) {
        this.iterator = new EnumerationIterator<T>(enumeration);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    private class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> enumeration;

        private EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

