/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.jdt.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.eclipse.virgo.ide.bundlor.jdt.core.ArtifactAnalyserTypeVisitor;

public class AstTypeArtifactAnalyser
implements ArtifactAnalyzer {
    private static final String JAVA_EXT = ".java";
    private final IJavaProject javaProject;

    public AstTypeArtifactAnalyser(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void analyse(InputStream is, String name, PartialManifest model) throws Exception {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this.javaProject);
        parser.setSource(this.convertStreamToString(is).toCharArray());
        parser.setUnitName(name);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        ASTNode node = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        node.accept((ASTVisitor)new ArtifactAnalyserTypeVisitor(model));
    }

    public boolean canAnalyse(String name) {
        return name.endsWith(JAVA_EXT);
    }

    public String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                }
                catch (IOException iOException) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException2) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

