/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.io.File;
import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;

class PdeCompatibilityUtil {
    private static boolean isEclipse34 = true;

    PdeCompatibilityUtil() {
    }

    public static boolean isSystemFileEditorInput(IEditorInput input) {
        if (isEclipse34) {
            try {
                Class<?> systemFileEditorInputClass = Class.forName("org.eclipse.pde.internal.ui.editor.SystemFileEditorInput");
                return systemFileEditorInputClass.isInstance(input);
            }
            catch (ClassNotFoundException classNotFoundException) {
                isEclipse34 = false;
            }
            catch (Throwable throwable) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Failed to check for instance of SystemFileEditorInput"));
                isEclipse34 = false;
            }
        }
        return false;
    }

    public static IEditorInput createSystemFileEditorInput(IURIEditorInput input) {
        return PdeCompatibilityUtil.createSystemFileEditorInput(new File(input.getURI()));
    }

    public static IEditorInput createSystemFileEditorInput(File file) {
        if (isEclipse34) {
            try {
                Class<?> systemFileEditorInputClass = Class.forName("org.eclipse.pde.internal.ui.editor.SystemFileEditorInput");
                Constructor<?> constructor = systemFileEditorInputClass.getConstructor(File.class);
                return (IEditorInput)constructor.newInstance(file);
            }
            catch (ClassNotFoundException classNotFoundException) {
                isEclipse34 = false;
            }
            catch (Throwable throwable) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Failed to create instance of SystemFileEditorInput"));
                isEclipse34 = false;
            }
        }
        return null;
    }
}

