/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.virgo.ide.export.ParExportWizard;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.editors.ParGeneralInfoSection;
import org.eclipse.virgo.ide.ui.editors.ParXmlEditorPage;

public class ParOverviewPage
extends PDEFormPage
implements IHyperlinkListener {
    public static final String PAGE_ID = "par_overview";
    private static final String BUNDLE_CONTENT_SECTION_TEXT = "<form><p>The content of the PAR is made up of one section:</p><li style=\"image\" value=\"page\" bindent=\"5\"><a href=\"dependencies\">Dependencies</a>: lists all the bundles required by this PAR to compile and run.</li></form>";
    private ParGeneralInfoSection fInfoSection;
    private static String PAR_ACTION_SECTION_TEXT = "<form><p>Perform common actions on the PAR:</p><li style=\"image\" value=\"export\" bindent=\"5\"><a href=\"exportpar\">Export PAR</a>: export the contents of the PAR to a deployable JAR.</li></form>";

    public ParOverviewPage(FormEditor editor) {
        super(editor, PAGE_ID, "Overview");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setImage(ServerIdeUiPlugin.getImage("full/obj16/par_obj.gif"));
        form.setText(PDEUIMessages.ManifestEditor_OverviewPage_title);
        this.fillBody(managedForm, toolkit);
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout((boolean)true, (int)2));
        Composite left = toolkit.createComposite(body);
        left.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout((boolean)false, (int)1));
        left.setLayoutData((Object)new TableWrapData(256));
        this.fInfoSection = new ParGeneralInfoSection(this, left);
        managedForm.addPart((IFormPart)this.fInfoSection);
        Composite right = toolkit.createComposite(body);
        right.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout((boolean)false, (int)1));
        right.setLayoutData((Object)new TableWrapData(128));
        this.createParActionSection(managedForm, right, toolkit);
        this.createParContentSection(managedForm, right, toolkit);
    }

    private void createParContentSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        String sectionTitle = "PAR Content";
        Section section = this.createStaticSection(toolkit, parent, sectionTitle);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        FormText text = this.createClient(container, BUNDLE_CONTENT_SECTION_TEXT, true, toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("page", lp.get(PDEPluginImages.DESC_PAGE_OBJ, 8));
        text.addHyperlinkListener((IHyperlinkListener)this);
        section.setClient((Control)container);
    }

    private void createParActionSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        String sectionTitle = "PAR Actions";
        Section section = this.createStaticSection(toolkit, parent, sectionTitle);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        FormText text = this.createClient(container, PAR_ACTION_SECTION_TEXT, true, toolkit);
        text.addHyperlinkListener((IHyperlinkListener)this);
        section.setClient((Control)container);
    }

    protected final Section createStaticSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 6;
        section.setText(text);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout((boolean)false, (int)1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        return section;
    }

    protected Composite createStaticSectionClient(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout((boolean)false, (int)1));
        TableWrapData data = new TableWrapData(256);
        container.setLayoutData((Object)data);
        return container;
    }

    protected final FormText createClient(Composite section, String content, boolean parseTags, FormToolkit toolkit) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, parseTags, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        return text;
    }

    public void linkActivated(HyperlinkEvent e) {
        if (e.getHref().equals("dependencies")) {
            this.getEditor().setActivePage(ParXmlEditorPage.ID_EDITOR);
        } else if (e.getHref().equals("exportpar")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ParExportWizard wizard = new ParExportWizard();
                    WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                    wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(new Object[]{ParOverviewPage.this.fInfoSection.getParProject()}));
                    dialog.open();
                }
            });
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }
}

