/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.core.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.jdt.core.JdtCorePlugin;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathUtils;
import org.eclipse.virgo.ide.jdt.internal.core.util.ClasspathUtils;
import org.eclipse.virgo.ide.jdt.internal.core.util.MarkerUtils;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestManager;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestMangerWorkingCopy;
import org.eclipse.virgo.ide.manifest.core.dependencies.IDependencyLocator;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.ide.runtime.core.ServerUtils;
import org.eclipse.virgo.kernel.osgi.provisioning.tools.DependencyLocationException;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.wst.server.core.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerClasspathContainer
implements IClasspathContainer {
    public static final String CLASSPATH_ATTRIBUTE_VALUE = "org.eclipse.virgo.ide.jdt.core.CLASSPATH_ENTRY";
    public static final String MANIFEST_TIMESTAMP = "MANIFEST_TIMESTAMP";
    private static final String CLASSPATH_CONTAINER = "org.eclipse.virgo.ide.jdt.core.MANIFEST_CLASSPATH_CONTAINER";
    public static final String CLASSPATH_CONTAINER_DESCRIPTION = "Bundle Dependencies";
    public static final IPath CLASSPATH_CONTAINER_PATH = new Path("org.eclipse.virgo.ide.jdt.core.MANIFEST_CLASSPATH_CONTAINER");
    public static final String TEST_CLASSPATH_ATTRIBUTE_VALUE = "org.eclipse.virgo.ide.jdt.core.TEST_CLASSPATH_ENTRY";
    public static final IClasspathAttribute[] CLASSPATH_CONTAINER_ATTRIBUTE = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.nondependency", (String)"")};
    private static Map<IPath, IAccessRule> accessibleRules = new ConcurrentHashMap<IPath, IAccessRule>();
    private static final IClasspathAttribute[] CLASSPATH_ATTRIBUTES = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.virgo.ide.jdt.core.CLASSPATH_ENTRY", (String)"true")};
    private static final String PACKAGE_WILDCARD = "/*";
    private static final IClasspathAttribute[] TEST_CLASSPATH_ATTRIBUTES = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.virgo.ide.jdt.core.TEST_CLASSPATH_ENTRY", (String)"true")};
    private static final String WILDCARD_PATH = "**/*";
    private static final IAccessRule WILDCARD_ACCESSIBLE_RULE = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)0);
    private static final IAccessRule WILDCARD_NON_ACCESSIBLE_RULE = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)257);
    private IClasspathEntry[] entries;
    private volatile boolean initialized = false;
    private IJavaProject javaProject;
    private Map<String, IJavaProject> manifestLocationsByProject;
    private IRuntime[] serverRuntimes;

    private static IAccessRule getAccessibleRule(IPath path) {
        if (!accessibleRules.containsKey(path)) {
            accessibleRules.put(path, JavaCore.newAccessRule((IPath)path, (int)0));
        }
        return accessibleRules.get(path);
    }

    public ServerClasspathContainer(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.entries = new IClasspathEntry[0];
    }

    public ServerClasspathContainer(IJavaProject javaProject, IClasspathEntry[] entries) {
        this.javaProject = javaProject;
        this.entries = entries;
        this.initialized = true;
        this.serverRuntimes = ServerUtils.getTargettedRuntimes((IProject)javaProject.getProject());
    }

    public synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.initialized) {
            return this.entries;
        }
        this.refreshClasspathEntries();
        return this.entries;
    }

    public String getDescription() {
        return CLASSPATH_CONTAINER_DESCRIPTION;
    }

    public String getDescriptionSuffix() {
        StringBuilder builder = new StringBuilder();
        if (this.serverRuntimes != null && this.serverRuntimes.length > 0) {
            builder.append(" [");
            int i = 0;
            while (i < this.serverRuntimes.length) {
                if (this.serverRuntimes[i] != null) {
                    builder.append(this.serverRuntimes[i].getName());
                    if (i + 1 < this.serverRuntimes.length) {
                        builder.append(", ");
                    }
                }
                ++i;
            }
            builder.append("]");
        }
        return builder.toString();
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return CLASSPATH_CONTAINER_PATH;
    }

    public void refreshClasspathEntries() {
        block10: {
            this.manifestLocationsByProject = new HashMap<String, IJavaProject>();
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            IDependencyLocator locator = null;
            try {
                try {
                    BundleManifest manifest = BundleManifestCorePlugin.getBundleManifestManager().getBundleManifest(this.javaProject);
                    BundleManifest testManifest = BundleManifestCorePlugin.getBundleManifestManager().getTestBundleManifest(this.javaProject);
                    if (manifest != null) {
                        locator = this.createDependencyLocator(this.javaProject);
                        this.resolveDependencies(entries, manifest, locator, false);
                        if (testManifest != null) {
                            this.resolveDependencies(entries, testManifest, locator, true);
                        }
                    }
                }
                catch (Throwable e) {
                    JdtCorePlugin.log(e);
                    if (locator != null) {
                        locator.shutdown();
                    }
                    Collections.sort(entries, new Comparator<IClasspathEntry>(){

                        @Override
                        public int compare(IClasspathEntry entry1, IClasspathEntry entry2) {
                            String path1 = entry1.getPath().lastSegment();
                            String path2 = entry2.getPath().lastSegment();
                            return path1.compareTo(path2);
                        }
                    });
                    this.entries = entries.toArray(new IClasspathEntry[entries.size()]);
                    this.manifestLocationsByProject = null;
                    this.initialized = true;
                    ServerClasspathUtils.persistClasspathEntries(this.javaProject, this.entries);
                    this.saveTimestamp(BundleManifestUtils.locateManifest((IJavaProject)this.javaProject, (boolean)false));
                    this.saveTimestamp(BundleManifestUtils.locateManifest((IJavaProject)this.javaProject, (boolean)true));
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (locator != null) {
                    locator.shutdown();
                }
                Collections.sort(entries, new /* invalid duplicate definition of identical inner class */);
                this.entries = entries.toArray(new IClasspathEntry[entries.size()]);
                this.manifestLocationsByProject = null;
                this.initialized = true;
                ServerClasspathUtils.persistClasspathEntries(this.javaProject, this.entries);
                this.saveTimestamp(BundleManifestUtils.locateManifest((IJavaProject)this.javaProject, (boolean)false));
                this.saveTimestamp(BundleManifestUtils.locateManifest((IJavaProject)this.javaProject, (boolean)true));
                throw throwable;
            }
            if (locator != null) {
                locator.shutdown();
            }
            Collections.sort(entries, new /* invalid duplicate definition of identical inner class */);
            this.entries = entries.toArray(new IClasspathEntry[entries.size()]);
            this.manifestLocationsByProject = null;
            this.initialized = true;
            ServerClasspathUtils.persistClasspathEntries(this.javaProject, this.entries);
            this.saveTimestamp(BundleManifestUtils.locateManifest((IJavaProject)this.javaProject, (boolean)false));
            this.saveTimestamp(BundleManifestUtils.locateManifest((IJavaProject)this.javaProject, (boolean)true));
        }
    }

    private void saveTimestamp(IFile manifestFile) {
        if (manifestFile != null && manifestFile.exists()) {
            try {
                manifestFile.setPersistentProperty(new QualifiedName("org.eclipse.virgo.ide.jdt.core", MANIFEST_TIMESTAMP), Long.toString(manifestFile.getLocalTimeStamp()));
            }
            catch (CoreException e) {
                JdtCorePlugin.log(e);
            }
        }
    }

    private void addClasspathEntriesFromBundleClassPath(List<IClasspathEntry> entries, BundleManifest manifest, boolean testManifest) {
        List bundleClassPathEntries = manifest.getBundleClasspath();
        for (String bundleClassPathEntry : bundleClassPathEntries) {
            File bundleClassPathEntryFile;
            IPath bundleClassPathEntryPath;
            IResource resource = this.javaProject.getProject().findMember(bundleClassPathEntry.trim());
            if (".".equals(bundleClassPathEntry.trim()) || resource == null || (bundleClassPathEntryPath = resource.getRawLocation()) == null || (bundleClassPathEntryFile = bundleClassPathEntryPath.toFile()) == null || !bundleClassPathEntryFile.exists()) continue;
            this.createClasspathEntryForFile(entries, bundleClassPathEntryFile, testManifest, WILDCARD_ACCESSIBLE_RULE);
        }
    }

    private void addClasspathEntriesFromResolutionResult(List<IClasspathEntry> entries, Map<File, List<String>> dependencies, boolean testManifest) {
        IBundleManifestManager bundleManifestManager;
        LinkedHashSet resolvedPackageImports = new LinkedHashSet();
        for (Map.Entry<File, List<String>> entry : dependencies.entrySet()) {
            File file = entry.getKey();
            if (file != null) {
                Set<IAccessRule> allowedRules = this.createAccessRulesFromPackageImports(entry.getValue());
                if (file.isDirectory()) {
                    String fileName = file.toString().replace("\\", "/");
                    if (this.manifestLocationsByProject.containsKey(fileName)) {
                        this.createClasspathForProject(entries, fileName, testManifest, allowedRules.toArray(new IAccessRule[allowedRules.size()]));
                    }
                } else {
                    this.createClasspathEntryForFile(entries, file, testManifest, allowedRules.toArray(new IAccessRule[allowedRules.size()]));
                }
            }
            if (testManifest) continue;
            resolvedPackageImports.addAll(entry.getValue());
        }
        if (!testManifest && (bundleManifestManager = BundleManifestCorePlugin.getBundleManifestManager()) instanceof IBundleManifestMangerWorkingCopy) {
            ((IBundleManifestMangerWorkingCopy)bundleManifestManager).updateResolvedPackageImports(this.javaProject, resolvedPackageImports);
        }
    }

    private void addWorkspaceBundle(Set<String> workspaceBundles, IProject project) {
        String manifestFolder;
        if (project.isAccessible() && FacetUtils.isBundleProject((IResource)project) && (manifestFolder = BundleManifestUtils.locateManifestFolder((IJavaProject)JavaCore.create((IProject)project))) != null) {
            workspaceBundles.add(manifestFolder);
            this.manifestLocationsByProject.put(manifestFolder, JavaCore.create((IProject)project));
        }
    }

    private Set<IAccessRule> createAccessRulesFromPackageImports(List<String> packageImports) {
        LinkedHashSet<IAccessRule> allowedRules = new LinkedHashSet<IAccessRule>();
        for (String packageImport : packageImports) {
            allowedRules.add(ServerClasspathContainer.getAccessibleRule((IPath)new Path(String.valueOf(packageImport.replace('.', '/')) + PACKAGE_WILDCARD)));
        }
        allowedRules.add(WILDCARD_NON_ACCESSIBLE_RULE);
        return allowedRules;
    }

    private void createClasspathEntryForFile(List<IClasspathEntry> entries, File file, boolean testManifest, IAccessRule ... allowedRules) {
        Path path = new Path(file.getAbsolutePath());
        allowedRules = this.mergeAccessRules(entries, (IPath)path, allowedRules);
        if (testManifest) {
            entries.add(JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), (IPath)this.getSourceAttachmentPath(file), null, (IAccessRule[])allowedRules, (IClasspathAttribute[])TEST_CLASSPATH_ATTRIBUTES, (boolean)false));
        } else {
            entries.add(JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), (IPath)this.getSourceAttachmentPath(file), null, (IAccessRule[])allowedRules, (IClasspathAttribute[])CLASSPATH_ATTRIBUTES, (boolean)false));
        }
    }

    private void createClasspathForProject(List<IClasspathEntry> entries, String fileName, boolean testManifest, IAccessRule ... allowedRules) {
        IJavaProject referencedProject = this.manifestLocationsByProject.get(fileName);
        if (referencedProject == null || this.javaProject.equals(referencedProject)) {
            return;
        }
        IPath path = this.manifestLocationsByProject.get(fileName).getPath();
        allowedRules = this.mergeAccessRules(entries, path, allowedRules);
        if (testManifest) {
            entries.add(JavaCore.newProjectEntry((IPath)path, (IAccessRule[])allowedRules, (boolean)false, (IClasspathAttribute[])TEST_CLASSPATH_ATTRIBUTES, (boolean)false));
        } else {
            entries.add(JavaCore.newProjectEntry((IPath)path, (IAccessRule[])allowedRules, (boolean)false, (IClasspathAttribute[])CLASSPATH_ATTRIBUTES, (boolean)false));
        }
    }

    private IAccessRule[] mergeAccessRules(List<IClasspathEntry> entries, IPath path, IAccessRule ... allowedRules) {
        IClasspathEntry entry = null;
        for (IClasspathEntry existingEntry : entries) {
            if (!existingEntry.getPath().equals((Object)path)) continue;
            TreeSet<IAccessRule> existingRules = new TreeSet<IAccessRule>(new Comparator<IAccessRule>(){

                @Override
                public int compare(IAccessRule o1, IAccessRule o2) {
                    if (o1.getKind() == o2.getKind()) {
                        return o1.getPattern().toString().compareTo(o2.getPattern().toString());
                    }
                    if (o1.getKind() == 1) {
                        return 1;
                    }
                    if (o2.getKind() == 1) {
                        return -1;
                    }
                    if (o1.getKind() == 0) {
                        return 1;
                    }
                    if (o2.getKind() == 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            existingRules.addAll(Arrays.asList(existingEntry.getAccessRules()));
            existingRules.addAll(Arrays.asList(allowedRules));
            allowedRules = existingRules.toArray(new IAccessRule[existingRules.size()]);
            entry = existingEntry;
            break;
        }
        if (entry != null) {
            entries.remove(entry);
        }
        return allowedRules;
    }

    private IDependencyLocator createDependencyLocator(IJavaProject javaProject) throws CoreException, IOException {
        IProject project;
        final LinkedHashSet<String> workspaceBundles = new LinkedHashSet<String>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            HashSet<String> parBundles = new HashSet<String>();
            if (FacetUtils.isParProject((IResource)project)) {
                boolean hasBundle = false;
                Par par = FacetUtils.getParDefinition((IProject)project);
                if (par != null && par.getBundle() != null) {
                    for (Bundle bundle : par.getBundle()) {
                        if (bundle.getSymbolicName().equals(javaProject.getElementName())) {
                            hasBundle = true;
                        }
                        parBundles.add(bundle.getSymbolicName());
                    }
                }
                if (hasBundle) {
                    for (String bundleName : parBundles) {
                        IProject bundleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
                        this.addWorkspaceBundle(workspaceBundles, bundleProject);
                    }
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource instanceof IFile && resource.getFileExtension().equals("jar")) {
                                IPath jarLocation = resource.getRawLocation();
                                IPath resolvedJarLocation = JavaCore.getResolvedVariablePath((IPath)jarLocation);
                                if (resolvedJarLocation != null) {
                                    workspaceBundles.add(String.valueOf(resolvedJarLocation.removeLastSegments(1).toString()) + File.separator + "{bundle}");
                                } else {
                                    workspaceBundles.add(String.valueOf(jarLocation.removeLastSegments(1).toString()) + File.separator + "{bundle}");
                                }
                            }
                            return true;
                        }
                    }, 1, false);
                }
            }
            ++n2;
        }
        iProjectArray = javaProject.getProject().getDescription().getReferencedProjects();
        n = iProjectArray.length;
        n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            this.addWorkspaceBundle(workspaceBundles, project);
            ++n2;
        }
        this.addWorkspaceBundle(workspaceBundles, javaProject.getProject());
        this.serverRuntimes = ServerUtils.getTargettedRuntimes((IProject)javaProject.getProject());
        ClasspathUtils.adjustLastModifiedDate(javaProject, false);
        ClasspathUtils.adjustLastModifiedDate(javaProject, true);
        return ServerUtils.createDependencyLocator((IProject)javaProject.getProject(), (String[])workspaceBundles.toArray(new String[workspaceBundles.size()]));
    }

    private IPath getSourceAttachmentPath(File file) {
        IPath sourceAttachmentPath = ClasspathUtils.getSourceAttachment(this.javaProject, file);
        if (sourceAttachmentPath != null) {
            return sourceAttachmentPath;
        }
        File sourceFile = ServerUtils.getSourceFile((URI)file.toURI());
        if (sourceFile != null && sourceFile.exists() && sourceFile.canRead()) {
            sourceAttachmentPath = new Path(sourceFile.getAbsolutePath());
        }
        return sourceAttachmentPath;
    }

    private void handleDependencyLocationException(DependencyLocationException e, boolean testManifest) {
        MarkerUtils.createErrorMarkers(e, this.javaProject, testManifest);
    }

    private void resolveDependencies(List<IClasspathEntry> entries, BundleManifest manifest, IDependencyLocator locator, boolean testManifest) {
        DependencyLocationException dependencyLocationException = null;
        if (locator != null) {
            try {
                try {
                    this.addClasspathEntriesFromResolutionResult(entries, locator.locateDependencies(manifest), testManifest);
                    this.addClasspathEntriesFromBundleClassPath(entries, manifest, testManifest);
                }
                catch (DependencyLocationException e) {
                    dependencyLocationException = e;
                    this.addClasspathEntriesFromResolutionResult(entries, e.getSatisfiedDependencies(), testManifest);
                    this.addClasspathEntriesFromBundleClassPath(entries, manifest, testManifest);
                    this.handleDependencyLocationException(dependencyLocationException, testManifest);
                }
            }
            finally {
                this.handleDependencyLocationException(dependencyLocationException, testManifest);
            }
        }
    }
}

