/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugElement;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugTarget;
import org.eclipse.viatra.transformation.debug.model.TransformationVariable;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelElement;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelProvider;

public class TransformationValue
extends TransformationDebugElement
implements IValue {
    private List<TransformationVariable> transformationVariables = Lists.newArrayList();
    private Object value;
    private boolean initialized = false;
    private final TransformationModelProvider modelProvider;

    public TransformationValue(TransformationDebugTarget target, Object value, TransformationModelProvider modelProvider) {
        super(target);
        this.value = value;
        this.modelProvider = modelProvider;
    }

    public Object getValue() {
        return this.value;
    }

    public void addTransformationVariable(TransformationVariable variable) {
        this.transformationVariables.add(variable);
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.value instanceof TransformationModelElement) {
            return ((TransformationModelElement)this.value).getTypeAttribute();
        }
        return this.value.getClass().getSimpleName();
    }

    public String getValueString() throws DebugException {
        ReflectiveItemProviderAdapterFactory adapterFactory = new ReflectiveItemProviderAdapterFactory();
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        if (this.value == null) {
            return "NULL";
        }
        if (this.value instanceof TransformationModelElement) {
            String nameAttribute = ((TransformationModelElement)this.value).getNameAttribute();
            return ((TransformationModelElement)this.value).getTypeAttribute() + (String)(nameAttribute.isEmpty() ? " " : " \"" + nameAttribute + "\" ") + "ID=" + String.valueOf(((TransformationModelElement)this.value).getId());
        }
        if (this.value instanceof List) {
            Object[] arguments = ((ParameterizedType)this.value.getClass().getGenericSuperclass()).getActualTypeArguments();
            return this.value.getClass().getSimpleName() + "<" + Joiner.on((String)",").join(arguments) + ">";
        }
        return adapterFactoryLabelProvider.getText(this.value);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return this.transformationVariables.toArray(new IVariable[this.transformationVariables.size()]);
    }

    private void initialize() {
        block7: {
            block8: {
                block6: {
                    if (!(this.value instanceof EObject)) break block6;
                    EObject eObject = (EObject)this.value;
                    EList eStructuralFeatures = eObject.eClass().getEStructuralFeatures();
                    for (EStructuralFeature eSFeature : eStructuralFeatures) {
                        Object eValue = eObject.eGet(eSFeature);
                        String label = eSFeature.getName();
                        this.transformationVariables.add(this.createTransformationVariable(eValue, label));
                    }
                    break block7;
                }
                if (!(this.value instanceof TransformationModelElement)) break block8;
                TransformationModelElement element = (TransformationModelElement)this.value;
                this.modelProvider.loadElementContent(element);
                Map attributes = element.getAttributes();
                for (Map.Entry attrEntry : attributes.entrySet()) {
                    String attrLabel = (String)attrEntry.getKey();
                    if (attrLabel.equals("EObjectType")) continue;
                    this.transformationVariables.add(this.createTransformationVariable("\"" + (String)attrEntry.getValue() + "\"", attrLabel));
                }
                Map crossReferences = element.getCrossReferences();
                for (Map.Entry entry : crossReferences.entrySet()) {
                    String referenceLabel = (String)entry.getKey();
                    Collection collection = (Collection)entry.getValue();
                    if (collection.size() == 1) {
                        this.transformationVariables.add(this.createTransformationVariable(collection.iterator().next(), referenceLabel));
                        continue;
                    }
                    this.transformationVariables.add(this.createTransformationVariable(collection, referenceLabel));
                }
                Map map = element.getContainments();
                for (Map.Entry entry : map.entrySet()) {
                    this.transformationVariables.add(this.createTransformationVariable(entry.getValue(), (String)entry.getKey()));
                }
                break block7;
            }
            if (!(this.value instanceof List)) break block7;
            List eList = (List)this.value;
            for (Object object : eList) {
                String string = "[" + Integer.toString(eList.indexOf(object)) + "]";
                this.transformationVariables.add(this.createTransformationVariable(object, string));
            }
        }
    }

    protected TransformationVariable createTransformationVariable(Object value, String parameterName) {
        if (value == null) {
            TransformationValue eTValue = new TransformationValue((TransformationDebugTarget)this.getDebugTarget(), "NULL", this.modelProvider);
            return new TransformationVariable((TransformationDebugTarget)this.getDebugTarget(), parameterName, eTValue);
        }
        TransformationValue eTValue = new TransformationValue((TransformationDebugTarget)this.getDebugTarget(), value, this.modelProvider);
        return new TransformationVariable((TransformationDebugTarget)this.getDebugTarget(), parameterName, eTValue);
    }

    public boolean hasVariables() throws DebugException {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return !this.transformationVariables.isEmpty();
    }
}

