/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.internal.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IMatchUpdateListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryModelUpdateListener;
import org.eclipse.viatra.query.runtime.api.scope.ViatraBaseIndexChangeListener;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.internal.engine.ListenerContainer;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public final class ModelUpdateProvider
extends ListenerContainer<ViatraQueryModelUpdateListener> {
    private final AdvancedViatraQueryEngine queryEngine;
    private ViatraQueryModelUpdateListener.ChangeLevel currentChange = ViatraQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
    private ViatraQueryModelUpdateListener.ChangeLevel maxLevel = ViatraQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
    private final Map<ViatraQueryModelUpdateListener.ChangeLevel, Collection<ViatraQueryModelUpdateListener>> listenerMap;
    private final Logger logger;
    private final ViatraBaseIndexChangeListener indexListener = new ViatraBaseIndexChangeListener(){

        @Override
        public boolean onlyOnIndexChange() {
            return false;
        }

        @Override
        public void notifyChanged(boolean indexChanged) {
            ModelUpdateProvider.this.currentChange = indexChanged ? ModelUpdateProvider.this.currentChange.changeOccured(ViatraQueryModelUpdateListener.ChangeLevel.INDEX) : ModelUpdateProvider.this.currentChange.changeOccured(ViatraQueryModelUpdateListener.ChangeLevel.MODEL);
            ModelUpdateProvider.this.notifyListeners();
        }
    };
    private final IMatchUpdateListener<IPatternMatch> matchSetListener = new IMatchUpdateListener<IPatternMatch>(){

        @Override
        public void notifyDisappearance(IPatternMatch match) {
            ModelUpdateProvider.this.currentChange = ModelUpdateProvider.this.currentChange.changeOccured(ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET);
        }

        @Override
        public void notifyAppearance(IPatternMatch match) {
            ModelUpdateProvider.this.currentChange = ModelUpdateProvider.this.currentChange.changeOccured(ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET);
        }
    };
    private final ViatraQueryEngineLifecycleListener selfListener = new ViatraQueryEngineLifecycleListener(){

        @Override
        public void matcherInstantiated(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
            if (ModelUpdateProvider.this.maxLevel.compareTo(ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET) >= 0) {
                ModelUpdateProvider.this.queryEngine.addMatchUpdateListener(matcher, ModelUpdateProvider.this.matchSetListener, false);
            }
        }

        @Override
        public void engineWiped() {
        }

        @Override
        public void engineDisposed() {
            ModelUpdateProvider.this.removeBaseIndexChangeListener();
            ModelUpdateProvider.this.listenerMap.clear();
            ModelUpdateProvider.this.maxLevel = ViatraQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
        }

        @Override
        public void engineBecameTainted(String description, Throwable t) {
        }
    };

    public ModelUpdateProvider(AdvancedViatraQueryEngine queryEngine, Logger logger) {
        this.queryEngine = queryEngine;
        this.logger = logger;
        this.listenerMap = new EnumMap<ViatraQueryModelUpdateListener.ChangeLevel, Collection<ViatraQueryModelUpdateListener>>(ViatraQueryModelUpdateListener.ChangeLevel.class);
    }

    @Override
    protected void listenerAdded(ViatraQueryModelUpdateListener listener) {
        if (this.listenerMap.isEmpty()) {
            try {
                this.queryEngine.getBaseIndex().addBaseIndexChangeListener(this.indexListener);
                this.queryEngine.addLifecycleListener(this.selfListener);
            }
            catch (ViatraQueryException e) {
                throw new IllegalStateException("Model update listener used on engine without base index", (Throwable)((Object)e));
            }
        }
        ViatraQueryModelUpdateListener.ChangeLevel changeLevel = listener.getLevel();
        this.listenerMap.computeIfAbsent(changeLevel, k -> CollectionsFactory.createSet()).add(listener);
        ViatraQueryModelUpdateListener.ChangeLevel oldMaxLevel = this.maxLevel;
        this.maxLevel = this.maxLevel.changeOccured(changeLevel);
        if (!this.maxLevel.equals((Object)oldMaxLevel) && ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET.compareTo(oldMaxLevel) > 0 && ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET.compareTo(this.maxLevel) <= 0) {
            for (ViatraQueryMatcher<? extends IPatternMatch> viatraQueryMatcher : this.queryEngine.getCurrentMatchers()) {
                this.queryEngine.addMatchUpdateListener(viatraQueryMatcher, this.matchSetListener, false);
            }
        }
    }

    @Override
    protected void listenerRemoved(ViatraQueryModelUpdateListener listener) {
        ViatraQueryModelUpdateListener.ChangeLevel changeLevel = listener.getLevel();
        Collection old = this.listenerMap.getOrDefault((Object)changeLevel, Collections.emptySet());
        boolean removed = old.remove(listener);
        if (removed) {
            if (old.isEmpty()) {
                this.listenerMap.remove((Object)changeLevel);
            }
        } else {
            this.handleUnsuccesfulRemove(listener);
        }
        this.updateMaxLevel();
        if (this.listenerMap.isEmpty()) {
            this.queryEngine.removeLifecycleListener(this.selfListener);
            this.removeBaseIndexChangeListener();
        }
    }

    private void removeBaseIndexChangeListener() {
        try {
            this.queryEngine.getBaseIndex().removeBaseIndexChangeListener(this.indexListener);
        }
        catch (ViatraQueryException e) {
            throw new IllegalStateException("Model update listener used on engine without base index", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateMaxLevel() {
        if (!this.listenerMap.containsKey((Object)this.maxLevel)) {
            void var1_2;
            ViatraQueryModelUpdateListener.ChangeLevel changeLevel = ViatraQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
            for (ViatraQueryModelUpdateListener.ChangeLevel level : new HashSet<ViatraQueryModelUpdateListener.ChangeLevel>(this.listenerMap.keySet())) {
                ViatraQueryModelUpdateListener.ChangeLevel changeLevel2 = var1_2.changeOccured(level);
            }
            this.maxLevel = var1_2;
        }
        if (this.maxLevel.compareTo(ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET) < 0) {
            for (ViatraQueryMatcher<? extends IPatternMatch> viatraQueryMatcher : this.queryEngine.getCurrentMatchers()) {
                this.queryEngine.removeMatchUpdateListener(viatraQueryMatcher, this.matchSetListener);
            }
        }
    }

    private void handleUnsuccesfulRemove(ViatraQueryModelUpdateListener listener) {
        for (Map.Entry<ViatraQueryModelUpdateListener.ChangeLevel, Collection<ViatraQueryModelUpdateListener>> entry : this.listenerMap.entrySet()) {
            Collection<ViatraQueryModelUpdateListener> existingListeners = entry.getValue();
            if (!existingListeners.remove(listener)) continue;
            this.logger.error((Object)("Listener " + String.valueOf(listener) + " change level changed since initialization!"));
            if (existingListeners.isEmpty()) {
                this.listenerMap.remove((Object)entry.getKey());
            }
            return;
        }
        this.logger.error((Object)("Listener " + String.valueOf(listener) + " already removed from map (e.g. engine was already disposed)!"));
    }

    private void notifyListeners() {
        ViatraQueryModelUpdateListener.ChangeLevel tempLevel = this.currentChange;
        this.currentChange = ViatraQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
        if (!this.listenerMap.isEmpty()) {
            for (ViatraQueryModelUpdateListener.ChangeLevel level : new HashSet<ViatraQueryModelUpdateListener.ChangeLevel>(this.listenerMap.keySet())) {
                if (tempLevel.compareTo(level) < 0) continue;
                for (ViatraQueryModelUpdateListener listener : new ArrayList<ViatraQueryModelUpdateListener>(this.listenerMap.get((Object)level))) {
                    try {
                        listener.notifyChanged(tempLevel);
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("VIATRA Query encountered an error in delivering model update notification to listener " + String.valueOf(listener) + "."), (Throwable)ex);
                    }
                }
            }
        } else {
            throw new IllegalStateException("Notify listeners must not be called without listeners! Maybe an update callback was not removed correctly.");
        }
    }
}

