/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryHintOption;

public class HintsPropertySource
implements IPropertySource {
    private final QueryEvaluationHint hint;

    public HintsPropertySource(QueryEvaluationHint hint) {
        this.hint = hint;
    }

    public Object getEditableValue() {
        return this;
    }

    public String toString() {
        int numOverrides = this.hint.getBackendHintSettings().size();
        switch (numOverrides) {
            case 0: {
                return "No hints specified";
            }
            case 1: {
                return "1 overridden hint option";
            }
        }
        return String.format("%d overridden hint options", numOverrides);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String category = "Hints";
        ArrayList hints = Lists.newArrayList();
        Consumer<QueryHintOption> _function = option -> {
            String _qualifiedName = option.getQualifiedName();
            PropertyDescriptor property = new PropertyDescriptor(option, _qualifiedName);
            property.setCategory("Hints");
            hints.add(property);
        };
        this.hint.getBackendHintSettings().keySet().forEach(_function);
        return hints.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        Object hintValue = this.hint.getBackendHintSettings().get(id);
        return hintValue;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

