/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.connector;

import java.util.Objects;
import org.eclipse.viatra.query.runtime.extensibility.IQueryGroupProvider;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.connector.AbstractRegistrySourceConnector;

public class QueryGroupProviderSourceConnector
extends AbstractRegistrySourceConnector {
    IQueryGroupProvider queryGroupProvider;

    public QueryGroupProviderSourceConnector(String identifier, IQueryGroupProvider provider, boolean includeInDefaultViews) {
        super(identifier, includeInDefaultViews);
        this.queryGroupProvider = provider;
    }

    public void setQueryGroupProvider(IQueryGroupProvider queryGroupProvider) {
        Objects.requireNonNull(queryGroupProvider, "Query group provider must not be null!");
        IQueryGroupProvider oldProvider = this.queryGroupProvider;
        for (IQuerySpecificationProvider specificationProvider : oldProvider.getQuerySpecificationProviders()) {
            for (IConnectorListener iConnectorListener : this.listeners) {
                iConnectorListener.querySpecificationRemoved(this, specificationProvider);
            }
        }
        for (IQuerySpecificationProvider specificationProvider : queryGroupProvider.getQuerySpecificationProviders()) {
            for (IConnectorListener iConnectorListener : this.listeners) {
                iConnectorListener.querySpecificationAdded(this, specificationProvider);
            }
        }
        this.queryGroupProvider = queryGroupProvider;
    }

    @Override
    protected void sendQuerySpecificationsToListener(IConnectorListener listener) {
        for (IQuerySpecificationProvider specificationProvider : this.queryGroupProvider.getQuerySpecificationProviders()) {
            listener.querySpecificationAdded(this, specificationProvider);
        }
    }
}

