/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import java.math.BigInteger;
import org.eclipse.uomo.units.AbstractSystemOfUnits;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.Messages;
import org.eclipse.uomo.units.impl.AlternateUnit;
import org.eclipse.uomo.units.impl.BaseUnit;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.eclipse.uomo.units.impl.TransformedUnit;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.unitsofmeasurement.quantity.Acceleration;
import org.unitsofmeasurement.quantity.AmountOfSubstance;
import org.unitsofmeasurement.quantity.Angle;
import org.unitsofmeasurement.quantity.Area;
import org.unitsofmeasurement.quantity.CatalyticActivity;
import org.unitsofmeasurement.quantity.Dimensionless;
import org.unitsofmeasurement.quantity.ElectricCapacitance;
import org.unitsofmeasurement.quantity.ElectricCharge;
import org.unitsofmeasurement.quantity.ElectricConductance;
import org.unitsofmeasurement.quantity.ElectricCurrent;
import org.unitsofmeasurement.quantity.ElectricInductance;
import org.unitsofmeasurement.quantity.ElectricPotential;
import org.unitsofmeasurement.quantity.ElectricResistance;
import org.unitsofmeasurement.quantity.Energy;
import org.unitsofmeasurement.quantity.Force;
import org.unitsofmeasurement.quantity.Frequency;
import org.unitsofmeasurement.quantity.Illuminance;
import org.unitsofmeasurement.quantity.Information;
import org.unitsofmeasurement.quantity.IonizingRadiation;
import org.unitsofmeasurement.quantity.Length;
import org.unitsofmeasurement.quantity.LuminousFlux;
import org.unitsofmeasurement.quantity.LuminousIntensity;
import org.unitsofmeasurement.quantity.MagneticFlux;
import org.unitsofmeasurement.quantity.MagneticFluxDensity;
import org.unitsofmeasurement.quantity.MagnetomotiveForce;
import org.unitsofmeasurement.quantity.Mass;
import org.unitsofmeasurement.quantity.Power;
import org.unitsofmeasurement.quantity.Pressure;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.quantity.RadiationDoseAbsorbed;
import org.unitsofmeasurement.quantity.RadiationDoseEffective;
import org.unitsofmeasurement.quantity.RadioactiveActivity;
import org.unitsofmeasurement.quantity.SolidAngle;
import org.unitsofmeasurement.quantity.Temperature;
import org.unitsofmeasurement.quantity.Time;
import org.unitsofmeasurement.quantity.Velocity;
import org.unitsofmeasurement.quantity.Volume;
import org.unitsofmeasurement.unit.SystemOfUnits;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public final class SI
extends AbstractSystemOfUnits {
    private static final SI INSTANCE = new SI();
    public static final Unit<ElectricCurrent> AMPERE = SI.addUnit(new BaseUnit(Messages.SI_A));
    public static final Unit<LuminousIntensity> CANDELA = SI.addUnit(new BaseUnit(Messages.SI_cd));
    public static final Unit<Temperature> KELVIN = SI.addUnit(new BaseUnit(Messages.SI_K));
    public static final Unit<Mass> KILOGRAM = SI.addUnit(new BaseUnit(Messages.SI_kg, Messages.SI_kg_name));
    public static final Unit<Length> METRE = SI.addUnit(new BaseUnit(Messages.SI_m, Messages.SI_m_name));
    public static final Unit<AmountOfSubstance> MOLE = SI.addUnit(new BaseUnit(Messages.SI_mol));
    public static final Unit<Time> SECOND = SI.addUnit(new BaseUnit(Messages.SI_s));
    public static final Unit<MagnetomotiveForce> AMPERE_TURN = SI.addUnit(new AlternateUnit(Messages.SI_At, (AbstractUnit)AMPERE));
    public static final Unit<Mass> GRAM = KILOGRAM.divide(1000.0);
    public static final Unit<Angle> RADIAN = SI.addUnit(new AlternateUnit(Messages.SI_rad, AbstractUnit.ONE));
    public static final Unit<SolidAngle> STERADIAN = SI.addUnit(new AlternateUnit(Messages.SI_sr, AbstractUnit.ONE));
    public static final Unit<Information> BIT = SI.addUnit(new AlternateUnit(Messages.SI_bit, AbstractUnit.ONE));
    public static final Unit<Frequency> HERTZ = SI.addUnit(new AlternateUnit(Messages.SI_Hz, (AbstractUnit)AbstractUnit.ONE.divide(SECOND)));
    public static final Unit<Force> NEWTON = SI.addUnit(new AlternateUnit(Messages.SI_N, (AbstractUnit)METRE.multiply(KILOGRAM).divide(SECOND.pow(2))));
    public static final Unit<Pressure> PASCAL = SI.addUnit(new AlternateUnit(Messages.SI_Pa, (AbstractUnit)NEWTON.divide(METRE.pow(2))));
    public static final Unit<Energy> JOULE = SI.addUnit(new AlternateUnit(Messages.SI_J, (AbstractUnit)NEWTON.multiply(METRE)));
    public static final Unit<Power> WATT = SI.addUnit(new AlternateUnit(Messages.SI_W, (AbstractUnit)JOULE.divide(SECOND)));
    public static final Unit<ElectricCharge> COULOMB = SI.addUnit(new AlternateUnit(Messages.SI_C, (AbstractUnit)SECOND.multiply(AMPERE)));
    public static final Unit<ElectricPotential> VOLT = SI.addUnit(new AlternateUnit(Messages.SI_V, (AbstractUnit)WATT.divide(AMPERE)));
    public static final Unit<ElectricCapacitance> FARAD = SI.addUnit(new AlternateUnit(Messages.SI_F, (AbstractUnit)COULOMB.divide(VOLT)));
    public static final Unit<ElectricResistance> OHM = SI.addUnit(new AlternateUnit(Messages.SI_OhmS, (AbstractUnit)VOLT.divide(AMPERE)));
    public static final Unit<ElectricConductance> SIEMENS = SI.addUnit(new AlternateUnit(Messages.SI_S, (AbstractUnit)AMPERE.divide(VOLT)));
    public static final Unit<MagneticFlux> WEBER = SI.addUnit(new AlternateUnit(Messages.SI_Wb, (AbstractUnit)VOLT.multiply(SECOND)));
    public static final Unit<MagneticFluxDensity> TESLA = SI.addUnit(new AlternateUnit(Messages.SI_T, (AbstractUnit)WEBER.divide(METRE.pow(2))));
    public static final Unit<ElectricInductance> HENRY = SI.addUnit(new AlternateUnit(Messages.SI_H, (AbstractUnit)WEBER.divide(AMPERE)));
    public static final Unit<Temperature> CELSIUS = SI.addUnit(KELVIN.add(273.15));
    public static final Unit<LuminousFlux> LUMEN = SI.addUnit(new AlternateUnit(Messages.SI_lm, (AbstractUnit)CANDELA.multiply(STERADIAN)));
    public static final Unit<Illuminance> LUX = SI.addUnit(new AlternateUnit(Messages.SI_lx, (AbstractUnit)LUMEN.divide(METRE.pow(2))));
    public static final Unit<RadioactiveActivity> BECQUEREL = SI.addUnit(new AlternateUnit(Messages.SI_Bq, (AbstractUnit)AbstractUnit.ONE.divide(SECOND)));
    public static final Unit<RadiationDoseAbsorbed> GRAY = SI.addUnit(new AlternateUnit(Messages.SI_Gy, (AbstractUnit)JOULE.divide(KILOGRAM)));
    public static final Unit<RadiationDoseEffective> SIEVERT = SI.addUnit(new AlternateUnit(Messages.SI_Sv, (AbstractUnit)JOULE.divide(KILOGRAM)));
    public static final Unit<CatalyticActivity> KATAL = SI.addUnit(new AlternateUnit(Messages.SI_kat, (AbstractUnit)MOLE.divide(SECOND)));
    public static final Unit<Velocity> METRES_PER_SECOND = SI.addUnit(new ProductUnit((AbstractUnit)METRE.divide(SECOND)));
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit((AbstractUnit)METRES_PER_SECOND.divide(SECOND)));
    public static final Unit<Area> SQUARE_METRE = SI.addUnit(new ProductUnit((AbstractUnit)METRE.multiply(METRE)));
    public static final Unit<Volume> CUBIC_METRE = SI.addUnit(new ProductUnit((AbstractUnit)SQUARE_METRE.multiply(METRE)));
    public static final TransformedUnit<Dimensionless> PERCENT = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, new RationalConverter(1L, 100L));
    public static final Unit<IonizingRadiation> ROENTGEN = SI.addUnit(COULOMB.divide(KILOGRAM).multiply(2.58E-4), Messages.NonSI_R_name);

    public static final SystemOfUnits getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public static class Prefix {
        private static final RationalConverter E24 = new RationalConverter(BigInteger.TEN.pow(24), BigInteger.ONE);
        private static final RationalConverter E21 = new RationalConverter(BigInteger.TEN.pow(21), BigInteger.ONE);
        private static final RationalConverter E18 = new RationalConverter(BigInteger.TEN.pow(18), BigInteger.ONE);
        private static final RationalConverter E15 = new RationalConverter(BigInteger.TEN.pow(15), BigInteger.ONE);
        private static final RationalConverter E12 = new RationalConverter(BigInteger.TEN.pow(12), BigInteger.ONE);
        private static final RationalConverter E9 = new RationalConverter(BigInteger.TEN.pow(9), BigInteger.ONE);
        private static final RationalConverter E6 = new RationalConverter(BigInteger.TEN.pow(6), BigInteger.ONE);
        private static final RationalConverter E3 = new RationalConverter(BigInteger.TEN.pow(3), BigInteger.ONE);
        private static final RationalConverter E2 = new RationalConverter(BigInteger.TEN.pow(2), BigInteger.ONE);
        private static final RationalConverter E1 = new RationalConverter(BigInteger.TEN.pow(1), BigInteger.ONE);
        private static final RationalConverter Em1 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(1));
        private static final RationalConverter Em2 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(2));
        private static final RationalConverter Em3 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(3));
        private static final RationalConverter Em6 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(6));
        private static final RationalConverter Em9 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(9));
        private static final RationalConverter Em12 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(12));
        private static final RationalConverter Em15 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(15));
        private static final RationalConverter Em18 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(18));
        private static final RationalConverter Em21 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(21));
        private static final RationalConverter Em24 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(24));

        private Prefix() {
        }

        public static <Q extends Quantity<Q>> Unit<Q> YOTTA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E24);
        }

        public static <Q extends Quantity<Q>> Unit<Q> ZETTA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E21);
        }

        public static <Q extends Quantity<Q>> Unit<Q> EXA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E18);
        }

        public static <Q extends Quantity<Q>> Unit<Q> PETA(Unit<Q> unit) {
            return (AbstractUnit)unit.transform((UnitConverter)E15);
        }

        public static <Q extends Quantity<Q>> Unit<Q> TERA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E12);
        }

        public static <Q extends Quantity<Q>> Unit<Q> GIGA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E9);
        }

        public static <Q extends Quantity<Q>> Unit<Q> MEGA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E6);
        }

        public static <Q extends Quantity<Q>> Unit<Q> KILO(Unit<Q> unit) {
            return unit.transform((UnitConverter)E3);
        }

        public static <Q extends Quantity<Q>> Unit<Q> HECTO(AbstractUnit<Q> unit) {
            return unit.transform(E2);
        }

        public static <Q extends Quantity<Q>> Unit<Q> DEKA(AbstractUnit<Q> unit) {
            return unit.transform(E1);
        }

        public static <Q extends Quantity<Q>> Unit<Q> DECI(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em1);
        }

        public static <Q extends Quantity<Q>> Unit<Q> CENTI(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em2);
        }

        public static <Q extends Quantity<Q>> Unit<Q> MILLI(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em3);
        }

        public static <Q extends Quantity<Q>> Unit<Q> MICRO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em6);
        }

        public static <Q extends Quantity<Q>> Unit<Q> NANO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em9);
        }

        public static <Q extends Quantity<Q>> Unit<Q> PICO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em12);
        }

        public static <Q extends Quantity<Q>> Unit<Q> FEMTO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em15);
        }

        public static final <Q extends Quantity<Q>> Unit<Q> ATTO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em18);
        }

        public static <Q extends Quantity<Q>> Unit<Q> ZEPTO(AbstractUnit<Q> unit) {
            return unit.transform(Em21);
        }

        public static <Q extends Quantity<Q>> Unit<Q> YOCTO(AbstractUnit<Q> unit) {
            return unit.transform(Em24);
        }
    }
}

