/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.trace;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tracecompass.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfIndexerStub;

public class TmfExperimentStub
extends TmfExperiment {
    private final Collection<IAnalysisModule> fAdditionalModules = new HashSet<IAnalysisModule>();

    public TmfExperimentStub() {
    }

    public TmfExperimentStub(String name, ITmfTrace[] traces, int blockSize) {
        super(ITmfEvent.class, name, traces, blockSize, null);
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfIndexerStub((ITmfTrace)this, interval);
    }

    public TmfIndexerStub getIndexer() {
        return (TmfIndexerStub)super.getIndexer();
    }

    public List<TmfCoalescedEventRequest> getAllPendingRequests() throws Exception {
        Method m = TmfEventProvider.class.getDeclaredMethod("getPendingRequests", new Class[0]);
        m.setAccessible(true);
        LinkedList list = (LinkedList)m.invoke((Object)this, new Object[0]);
        LinkedList<TmfCoalescedEventRequest> retList = new LinkedList<TmfCoalescedEventRequest>();
        for (Object element : list) {
            retList.add((TmfCoalescedEventRequest)element);
        }
        return retList;
    }

    public void clearAllPendingRequests() throws Exception {
        Method m = TmfEventProvider.class.getDeclaredMethod("clearPendingRequests", new Class[0]);
        m.setAccessible(true);
        m.invoke((Object)this, new Object[0]);
    }

    public void setTimerEnabledFlag(boolean enabled) throws Exception {
        Class[] paramTypes = new Class[]{Boolean.class};
        Method m = TmfEventProvider.class.getDeclaredMethod("setTimerEnabled", paramTypes);
        Object[] params = new Object[]{enabled};
        m.setAccessible(true);
        m.invoke((Object)this, params);
    }

    public void addAnalysisModule(IAnalysisModule module) {
        this.fAdditionalModules.add(module);
    }

    public IStatus validateWithTraces(List<ITmfTrace> traces) {
        if (((Object)((Object)this)).getClass() == TmfExperimentStub.class) {
            int confidence = 0;
            for (ITmfTrace trace : traces) {
                if (trace.getName().startsWith("A-")) {
                    confidence = 1;
                    continue;
                }
                if (!trace.getName().startsWith("E-")) continue;
                return new Status(4, "org.eclipse.tracecompass.tmf.core", "stubbed error case");
            }
            return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.tmf.core");
        }
        return new Status(4, "org.eclipse.tracecompass.tmf.core", "class extends TmfExperimentStub");
    }
}

