/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceType;
import org.junit.Assert;
import org.junit.Test;

public class TmfConfigurationSourceTypeTest {
    private static final String PATH = "/tmp/my-test.xml";
    private static final String ID = "my-test.xml";
    private static final String DESC = "descriptor";
    private static final @NonNull List<@NonNull ITmfConfigParamDescriptor> PARAM = ImmutableList.of((Object)new TmfConfigParamDescriptor.Builder().setKeyName("path").build());
    private static final String EXPECTED_TO_STRING = "TmfConfigurationSourceType[fName=/tmp/my-test.xml, fDescription=descriptor, fId=my-test.xml, fKeys=[TmfConfigParamDescriptor[fKeyName=path, fDataType=STRING, fIsRequired=true, fDescription=]]]";

    @Test
    public void testBuilder() {
        TmfConfigurationSourceType.Builder builder = new TmfConfigurationSourceType.Builder().setName(PATH).setId(ID).setDescription(DESC).setConfigParamDescriptors(PARAM);
        ITmfConfigurationSourceType config = builder.build();
        Assert.assertEquals((Object)PATH, (Object)config.getName());
        Assert.assertEquals((Object)ID, (Object)config.getId());
        Assert.assertEquals((Object)DESC, (Object)config.getDescription());
        Assert.assertEquals(PARAM, (Object)config.getConfigParamDescriptors());
    }

    @Test
    public void testBuilderMissingParams() {
        TmfConfigurationSourceType.Builder builder = new TmfConfigurationSourceType.Builder().setId(ID).setDescription(DESC).setConfigParamDescriptors(PARAM);
        try {
            builder.build();
            Assert.fail((String)"No exception created");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        builder = new TmfConfigurationSourceType.Builder().setName("  ").setId(ID).setDescription(DESC).setConfigParamDescriptors(PARAM);
        try {
            builder.build();
            Assert.fail((String)"No exception created");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        builder = new TmfConfigurationSourceType.Builder().setName(PATH).setDescription(DESC).setConfigParamDescriptors(PARAM);
        try {
            builder.build();
            Assert.fail((String)"No exception created");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        builder = new TmfConfigurationSourceType.Builder().setName(PATH).setId("\n").setDescription(DESC).setConfigParamDescriptors(PARAM);
        try {
            builder.build();
            Assert.fail((String)"No exception created");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        builder = new TmfConfigurationSourceType.Builder().setId(ID).setName(PATH);
        builder.build();
    }

    @Test
    public void testEquality() {
        TmfConfigurationSourceType.Builder builder = new TmfConfigurationSourceType.Builder().setName(PATH).setId(ID).setDescription(DESC).setConfigParamDescriptors(PARAM);
        ITmfConfigurationSourceType baseConfiguration = builder.build();
        ITmfConfigurationSourceType testConfig = builder.build();
        Assert.assertEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setName("Other path");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setName(PATH);
        builder.setId("Other Id");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setId(ID);
        builder.setDescription("Other desc");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setDescription(DESC);
        builder.setConfigParamDescriptors((List)ImmutableList.of((Object)new TmfConfigParamDescriptor.Builder().setKeyName("path2").build()));
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
    }

    @Test
    public void testToString() {
        TmfConfigurationSourceType.Builder builder = new TmfConfigurationSourceType.Builder().setName(PATH).setId(ID).setDescription(DESC).setConfigParamDescriptors(PARAM);
        Assert.assertEquals((Object)EXPECTED_TO_STRING, (Object)builder.build().toString());
    }

    @Test
    public void testHashCode() {
        TmfConfigurationSourceType.Builder builder = new TmfConfigurationSourceType.Builder().setName(PATH).setId(ID).setDescription(DESC).setConfigParamDescriptors(PARAM);
        ITmfConfigurationSourceType config1 = builder.build();
        builder = new TmfConfigurationSourceType.Builder().setName("/tmp/my-test.xml1").setId("my-test.xml1").setDescription("descriptor1").setConfigParamDescriptors((List)ImmutableList.of((Object)new TmfConfigParamDescriptor.Builder().setKeyName("path2").build()));
        ITmfConfigurationSourceType config2 = builder.build();
        Assert.assertEquals((long)config1.hashCode(), (long)config1.hashCode());
        Assert.assertEquals((long)config2.hashCode(), (long)config2.hashCode());
        Assert.assertNotEquals((long)config1.hashCode(), (long)config2.hashCode());
    }
}

