/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests;

import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlViewProfileTest
extends ControlViewTest {
    private static final boolean IS_LINUX = System.getProperty("os.name").contains("Linux");
    private static final String TEST_STREAM = "Profile.cfg";
    private static final String CREATE_PROFILE_SCENARIO_NAME = "ProfileTest";
    private static final String SESSION_NAME = String.valueOf(System.nanoTime());

    @Override
    protected String getTestStream() {
        return TEST_STREAM;
    }

    @Override
    protected String getSessionName() {
        return SESSION_NAME;
    }

    @Override
    @Test
    public void testTraceSessionTree() {
        Assume.assumeTrue((boolean)IS_LINUX);
        this.fProxy.setSessionName(this.getSessionName());
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_PROFILE_SCENARIO_NAME);
        this.testSaveSession();
        this.testDestroySession();
        this.testLoadSession();
        this.testDestroySession();
        this.fProxy.setProfileName(null);
        this.fProxy.deleteProfileFile();
        this.fProxy.setSessionName(null);
        this.testDisconnectFromNode();
    }

    private void testSaveSession() {
        this.fProxy.setProfileName(this.getSessionName());
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", SESSION_NAME});
        Assert.assertEquals((Object)SESSION_NAME, (Object)sessionItem.getText());
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Save...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Save Sessions").activate();
        shell.bot().button("OK").click();
        WaitUtils.waitForJobs();
    }

    private void testLoadSession() {
        SWTBotTreeItem nodeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName()});
        SWTBotTreeItem sessionGroupItem = nodeItem.getNode("Sessions");
        sessionGroupItem.select();
        SWTBotMenu menuBot = sessionGroupItem.contextMenu("Load...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Load Sessions").activate();
        SWTBotRadio button = shell.bot().radio("Remote");
        button.click();
        SWTBotTree shellTree = shell.bot().tree();
        SWTBotTreeItem profileItem = shellTree.getTreeItem(SESSION_NAME + ".lttng");
        profileItem.select();
        profileItem.click();
        shell.bot().button("OK").click();
        WaitUtils.waitForJobs();
        sessionGroupItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions"});
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)SESSION_NAME, (SWTBotTreeItem)sessionGroupItem));
        Assert.assertEquals((long)1L, (long)sessionGroupItem.getNodes().size());
    }
}

