/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table;

import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.ViewFilterDialog;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvAction;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvUtils;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.ITmfFilterableControl;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public abstract class AbstractSegmentStoreTableView
extends TmfView
implements ITmfFilterableControl {
    private static final String TMF_VIEW_UI_CONTEXT = "org.eclipse.tracecompass.tmf.ui.view.context";
    private final Action fExportAction = new ExportToTsvAction(){

        protected void exportToTsv(@Nullable OutputStream stream) {
            AbstractSegmentStoreTableView.this.exportToTsv(stream);
        }

        protected @Nullable Shell getShell() {
            return AbstractSegmentStoreTableView.this.getViewSite().getShell();
        }
    };
    private @Nullable AbstractSegmentStoreTableViewer fSegmentStoreViewer;
    private @Nullable ViewFilterDialog fFilterDialog = null;
    private List<IContextActivation> fActiveContexts = new ArrayList<IContextActivation>();
    private @Nullable IContextService fContextService = null;
    private @Nullable Action fFilterAction;

    public AbstractSegmentStoreTableView() {
        super("");
    }

    public void createPartControl(@Nullable Composite parent) {
        Action timeEventFilterAction;
        AbstractSegmentStoreTableViewer segmentStoreViewer;
        super.createPartControl(parent);
        SashForm sf = new SashForm(parent, 0);
        TableViewer tableViewer = new TableViewer((Composite)sf, 0x10010000);
        this.fSegmentStoreViewer = segmentStoreViewer = this.createSegmentStoreViewer(tableViewer);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.fExportAction);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            if (this.fSegmentStoreViewer != null) {
                this.fSegmentStoreViewer.traceSelected(signal);
            }
        }
        segmentStoreViewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(@Nullable FocusEvent e) {
                AbstractSegmentStoreTableView.this.deactivateContextService();
            }

            public void focusGained(@Nullable FocusEvent e) {
                AbstractSegmentStoreTableView.this.activateContextService();
            }
        });
        this.fFilterAction = timeEventFilterAction = new Action(){

            public void run() {
                ViewFilterDialog dialog = AbstractSegmentStoreTableView.this.fFilterDialog;
                if (dialog != null) {
                    AbstractSegmentStoreTableView.this.fFilterDialog = null;
                    dialog.close();
                }
                dialog = new ViewFilterDialog(segmentStoreViewer.getControl().getShell(), (ITmfFilterableControl)AbstractSegmentStoreTableView.this, segmentStoreViewer.getControl());
                AbstractSegmentStoreTableView.this.fFilterDialog = dialog;
                dialog.open();
            }
        };
        IWorkbenchPartSite site = this.getSite();
        this.fContextService = (IContextService)site.getWorkbenchWindow().getService(IContextService.class);
    }

    public void setFocus() {
        if (this.fSegmentStoreViewer != null) {
            this.fSegmentStoreViewer.getTableViewer().getControl().setFocus();
        }
        this.activateContextService();
    }

    public void dispose() {
        super.dispose();
        if (this.fSegmentStoreViewer != null) {
            this.fSegmentStoreViewer.dispose();
        }
    }

    protected abstract AbstractSegmentStoreTableViewer createSegmentStoreViewer(TableViewer var1);

    public @Nullable AbstractSegmentStoreTableViewer getSegmentStoreViewer() {
        return this.fSegmentStoreViewer;
    }

    @VisibleForTesting
    protected void exportToTsv(@Nullable OutputStream stream) {
        AbstractSegmentStoreTableViewer segmentStoreViewer = this.getSegmentStoreViewer();
        if (segmentStoreViewer == null) {
            return;
        }
        Table table = segmentStoreViewer.getTableViewer().getTable();
        ExportToTsvUtils.exportTableToTsv((Table)table, (OutputStream)stream);
    }

    private void activateContextService() {
        IContextService contextService = this.fContextService;
        if (this.fActiveContexts.isEmpty() && contextService != null) {
            this.fActiveContexts.add(Objects.requireNonNull(contextService.activateContext(TMF_VIEW_UI_CONTEXT)));
        }
    }

    private void deactivateContextService() {
        IContextService contextService = this.fContextService;
        if (contextService != null) {
            contextService.deactivateContexts(this.fActiveContexts);
            this.fActiveContexts.clear();
        }
    }

    public Action getFilterAction() {
        return Objects.requireNonNull(this.fFilterAction);
    }

    public void filterUpdated(@Nullable String regex, Set<String> filterRegexes) {
        AbstractSegmentStoreTableViewer segmentStoreViewer = this.fSegmentStoreViewer;
        if (segmentStoreViewer != null) {
            segmentStoreViewer.setLocalRegexes(filterRegexes);
        }
    }
}

