/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.jsontrace.core.job;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.jsontrace.core.Messages;
import org.eclipse.tracecompass.internal.provisional.jsontrace.core.trace.JsonTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class SortingJob
extends Job {
    private static final char CLOSE_BRACKET = ']';
    private static final char OPEN_BRACKET = '[';
    private static final int CHARS_PER_LINE_ESTIMATE = 50;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(SortingJob.class);
    private static final int CHUNK_SIZE = 65535;
    private static final Comparator<PartiallyParsedEvent> EVENT_COMPARATOR = Comparator.comparing(PartiallyParsedEvent::getTs);
    private final Integer fBracketsToSkip;
    private final String fTsKey;
    private final String fPath;
    private final ITmfTrace fTrace;

    public SortingJob(ITmfTrace trace, String path, String tsKey, int bracketsToSkip) {
        super(Messages.SortingJob_description);
        this.fTrace = trace;
        this.fPath = path;
        this.fTsKey = tsKey;
        this.fBracketsToSkip = bracketsToSkip;
    }

    public String getPath() {
        return this.fPath;
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 59[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void processMetadata(ITmfTrace trace, String dir, BufferedInputStream parser) throws IOException {
        this.processMetadata(trace, dir);
    }

    protected abstract void processMetadata(ITmfTrace var1, String var2) throws IOException;

    private static @Nullable PartiallyParsedEvent readNextEvent(BufferedInputStream parser, String key, int i) throws IOException {
        String event = JsonTrace.readNextEventString(parser::read);
        return event == null ? null : new PartiallyParsedEvent(key, event, i);
    }

    private static final class PartiallyParsedEvent {
        private static final @NonNull BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);
        private final BigDecimal fTs;
        private String fLine;
        private final int fPos;

        public PartiallyParsedEvent(String key, String string, int i) {
            this.fLine = string;
            int indexOf = string.indexOf(key);
            this.fPos = i;
            if (indexOf < 0) {
                this.fTs = MINUS_ONE;
            } else {
                BigDecimal ts;
                String number;
                int index = indexOf + key.length();
                int end = string.indexOf(44, index);
                if (end == -1) {
                    end = string.indexOf(125, index);
                }
                if (!(number = string.substring(index, end).trim().replace("\"", "")).isEmpty()) {
                    try {
                        ts = new BigDecimal(number);
                    }
                    catch (NumberFormatException e) {
                        ts = MINUS_ONE;
                    }
                } else {
                    ts = MINUS_ONE;
                }
                this.fTs = ts;
            }
        }

        public BigDecimal getTs() {
            return this.fTs;
        }

        static /* synthetic */ String access$0(PartiallyParsedEvent partiallyParsedEvent) {
            return partiallyParsedEvent.fLine;
        }

        static /* synthetic */ void access$1(PartiallyParsedEvent partiallyParsedEvent, String string) {
            partiallyParsedEvent.fLine = string;
        }

        static /* synthetic */ int access$2(PartiallyParsedEvent partiallyParsedEvent) {
            return partiallyParsedEvent.fPos;
        }
    }
}

