/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarkupParser {
    public static String parseAndTrimTextMarkup(Node parentNode) {
        return MarkupParser.parseMarkup(parentNode).trim();
    }

    private static String parseMarkup(Node parentNode) {
        NodeList children = parentNode.getChildNodes();
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 3) {
                text.append(MarkupParser.escapeText(childNode.getNodeValue()));
            } else if (childNode.getNodeType() == 1) {
                text.append('<');
                text.append(childNode.getNodeName());
                NamedNodeMap attributes = childNode.getAttributes();
                if (attributes != null) {
                    int x = 0;
                    while (x < attributes.getLength()) {
                        Node attribute = attributes.item(x);
                        String attributeName = attribute.getNodeName();
                        if (attributeName != null) {
                            text.append(' ');
                            text.append(attributeName);
                            text.append(" = \"");
                            text.append(attribute.getNodeValue());
                            text.append('\"');
                        }
                        ++x;
                    }
                }
                text.append('>');
                text.append(MarkupParser.parseMarkup(childNode));
                text.append("</");
                text.append(childNode.getNodeName());
                text.append('>');
            }
            ++i;
        }
        return text.toString();
    }

    public static String escapeText(String input) {
        StringBuilder result = new StringBuilder(input.length() + 10);
        int i = 0;
        while (i < input.length()) {
            MarkupParser.appendEscapedChar(result, input.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static void appendEscapedChar(StringBuilder buffer, char c) {
        String replacement = MarkupParser.getReplacement(c);
        if (replacement != null) {
            buffer.append(replacement);
        } else {
            buffer.append(c);
        }
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\t': {
                return " ";
            }
        }
        return null;
    }

    public static String createParagraph(String text, String imageTag) {
        boolean addParagraphTags;
        String result = "";
        String trimmed = text.trim();
        boolean bl = addParagraphTags = trimmed.length() < 3 || trimmed.charAt(0) != '<' || trimmed.charAt(1) != 'p' && trimmed.charAt(1) != 'l';
        if (addParagraphTags) {
            result = String.valueOf(result) + "<p>";
        }
        if (imageTag != null) {
            result = String.valueOf(result) + "<img href=\"";
            result = String.valueOf(result) + imageTag;
            result = String.valueOf(result) + "\"/> ";
        }
        result = String.valueOf(result) + trimmed;
        if (addParagraphTags) {
            result = String.valueOf(result) + "</p>";
        }
        return result;
    }
}

