/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.colors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSetting;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSettingsXML;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterDialog;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;

public class ColorsView
extends TmfView {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.ui.views.colors";
    private static final Image ADD_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/add_button.gif");
    private static final Image DELETE_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/delete_button.gif");
    private static final Image MOVE_UP_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/moveup_button.gif");
    private static final Image MOVE_DOWN_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/movedown_button.gif");
    private static final Image IMPORT_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/import_button.gif");
    private static final Image EXPORT_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/export_button.gif");
    private static final String THEME_BACKGROUND = "org.eclipse.tracecompass.tmf.ui.BACKGROUND";
    private static final String THEME_FOREGROUND = "org.eclipse.tracecompass.tmf.ui.FOREGROUND";
    protected Shell fShell;
    protected ScrolledComposite fScrolledComposite;
    protected Composite fListComposite;
    protected Composite fFillerComposite;
    protected ColorSettingRow fSelectedRow = null;
    protected TimeGraphColorScheme traceColorScheme = new TimeGraphColorScheme();
    protected Action fAddAction;
    protected Action fDeleteAction;
    protected Action fMoveUpAction;
    protected Action fMoveDownAction;
    protected Action fImportAction;
    protected Action fExportAction;
    protected List<ColorSetting> fColorSettings;

    public ColorsView() {
        super("Colors");
    }

    @Override
    public void createPartControl(Composite parent) {
        this.fShell = parent.getShell();
        this.fScrolledComposite = new ScrolledComposite(parent, 768);
        this.fScrolledComposite.setExpandHorizontal(true);
        this.fScrolledComposite.setExpandVertical(true);
        this.fListComposite = new Composite((Composite)this.fScrolledComposite, 0);
        this.fScrolledComposite.setContent((Control)this.fListComposite);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 1;
        this.fListComposite.setLayout((Layout)gl);
        this.fColorSettings = new ArrayList<ColorSetting>(Arrays.asList(ColorSettingsManager.getColorSettings()));
        for (ColorSetting colorSetting : this.fColorSettings) {
            new ColorSettingRow(this.fListComposite, colorSetting);
        }
        this.fFillerComposite = new Composite(this.fListComposite, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 0;
        this.fFillerComposite.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        this.fFillerComposite.setLayout((Layout)gl);
        Label fillerLabel = new Label(this.fFillerComposite, 0);
        fillerLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        fillerLabel.setBackground(Display.getDefault().getSystemColor(25));
        this.fFillerComposite.addPaintListener(e -> {
            if (this.fSelectedRow == null) {
                Color lineColor = Display.getDefault().getSystemColor(2);
                Point p = this.fFillerComposite.getSize();
                GC gc = e.gc;
                gc.setForeground(lineColor);
                gc.drawLine(0, 0, p.x - 1, 0);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorsView.this.fSelectedRow = null;
                ColorsView.this.refresh();
            }
        };
        fillerLabel.addMouseListener((MouseListener)mouseListener);
        this.fScrolledComposite.setMinSize(this.fListComposite.computeSize(-1, -1));
        this.fillToolBar();
    }

    public void setFocus() {
        this.fScrolledComposite.setFocus();
    }

    public void refresh() {
        this.fListComposite.layout();
        this.fScrolledComposite.setMinSize(this.fListComposite.computeSize(-1, -1));
        this.fListComposite.redraw(0, 0, this.fListComposite.getBounds().width, this.fListComposite.getBounds().height, true);
        if (this.fSelectedRow == null) {
            this.fDeleteAction.setEnabled(false);
            this.fMoveUpAction.setEnabled(false);
            this.fMoveDownAction.setEnabled(false);
        } else {
            this.fDeleteAction.setEnabled(true);
            this.fMoveUpAction.setEnabled(true);
            this.fMoveDownAction.setEnabled(true);
        }
    }

    private void fillToolBar() {
        this.fAddAction = new AddAction();
        this.fAddAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ADD_IMAGE));
        this.fAddAction.setToolTipText(Messages.ColorsView_AddActionToolTipText);
        this.fDeleteAction = new DeleteAction();
        this.fDeleteAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DELETE_IMAGE));
        this.fDeleteAction.setToolTipText(Messages.ColorsView_DeleteActionToolTipText);
        this.fDeleteAction.setEnabled(false);
        this.fMoveUpAction = new MoveUpAction();
        this.fMoveUpAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)MOVE_UP_IMAGE));
        this.fMoveUpAction.setToolTipText(Messages.ColorsView_MoveUpActionToolTipText);
        this.fMoveUpAction.setEnabled(false);
        this.fMoveDownAction = new MoveDownAction();
        this.fMoveDownAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)MOVE_DOWN_IMAGE));
        this.fMoveDownAction.setToolTipText(Messages.ColorsView_MoveDownActionToolTipText);
        this.fMoveDownAction.setEnabled(false);
        this.fExportAction = new ExportAction();
        this.fExportAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)EXPORT_IMAGE));
        this.fExportAction.setToolTipText(Messages.ColorsView_ExportActionToolTipText);
        this.fImportAction = new ImportAction();
        this.fImportAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)IMPORT_IMAGE));
        this.fImportAction.setToolTipText(Messages.ColorsView_ImportActionToolTipText);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.fAddAction);
        manager.add((IAction)this.fDeleteAction);
        manager.add((IAction)this.fMoveUpAction);
        manager.add((IAction)this.fMoveDownAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fExportAction);
        manager.add((IAction)this.fImportAction);
    }

    private static Color getThemeColor(String themeColorName) {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        Color c = colorRegistry.get(themeColorName);
        return c;
    }

    private class AddAction
    extends Action {
        private AddAction() {
        }

        public void run() {
            Color fc = ColorsView.getThemeColor(ColorsView.THEME_FOREGROUND);
            Color bc = ColorsView.getThemeColor(ColorsView.THEME_BACKGROUND);
            if (fc == null) {
                fc = Display.getDefault().getSystemColor(24);
            }
            if (bc == null) {
                bc = Display.getDefault().getSystemColor(25);
            }
            ColorSetting colorSetting = new ColorSetting((RGB)NonNullUtils.checkNotNull((Object)fc.getRGB()), (RGB)NonNullUtils.checkNotNull((Object)bc.getRGB()), (RGB)NonNullUtils.checkNotNull((Object)fc.getRGB()), null);
            ColorSettingRow row = new ColorSettingRow(ColorsView.this.fListComposite, colorSetting);
            if (ColorsView.this.fSelectedRow == null) {
                ColorsView.this.fColorSettings.add(colorSetting);
                row.moveAbove((Control)ColorsView.this.fFillerComposite);
            } else {
                ColorsView.this.fColorSettings.add(ColorsView.this.fColorSettings.indexOf(ColorsView.this.fSelectedRow.getColorSetting()), colorSetting);
                row.moveAbove((Control)ColorsView.this.fSelectedRow);
            }
            ColorsView.this.fSelectedRow = row;
            ColorsView.this.refresh();
            ColorSettingsManager.setColorSettings(ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
        }
    }

    private class ColorSettingRow
    extends Composite {
        ColorSetting fColorSetting;

        public ColorSettingRow(Composite parent, final ColorSetting colorSetting) {
            super(parent, 0);
            this.fColorSetting = colorSetting;
            this.setBackground(Display.getDefault().getSystemColor(25));
            this.setLayoutData(new GridData(4, 0x1000000, true, false));
            GridLayout gl = new GridLayout(7, false);
            gl.marginHeight = 1;
            gl.marginWidth = 1;
            gl.horizontalSpacing = 1;
            gl.verticalSpacing = 0;
            this.setLayout((Layout)gl);
            Button fgButton = new Button((Composite)this, 8);
            fgButton.setText(Messages.ColorsView_ForegroundButtonText);
            fgButton.setSize(fgButton.computeSize(-1, 19));
            fgButton.setBackground(Display.getDefault().getSystemColor(25));
            Button bgButton = new Button((Composite)this, 8);
            bgButton.setText(Messages.ColorsView_BackgroundButtonText);
            bgButton.setBackground(Display.getDefault().getSystemColor(25));
            final Composite labelComposite = new Composite((Composite)this, 0);
            labelComposite.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
            gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            labelComposite.setLayout((Layout)gl);
            labelComposite.setBackground(colorSetting.getBackgroundColor());
            final Label label = new Label(labelComposite, 0);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
            label.setText(" Text ");
            label.setForeground(colorSetting.getForegroundColor());
            label.setBackground(colorSetting.getBackgroundColor());
            fgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fSelectedRow = ColorSettingRow.this;
                    ColorsView.this.refresh();
                    ColorDialog dialog = new ColorDialog(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fShell);
                    dialog.setRGB(colorSetting.getForegroundRGB());
                    dialog.setText(Messages.ColorsView_ForegroundDialogText);
                    dialog.open();
                    RGB rgb = dialog.getRGB();
                    if (rgb != null) {
                        colorSetting.setForegroundRGB(rgb);
                        ColorSettingsManager.setColorSettings(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
                        label.setForeground(colorSetting.getForegroundColor());
                    }
                }
            });
            bgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fSelectedRow = ColorSettingRow.this;
                    ColorsView.this.refresh();
                    ColorDialog dialog = new ColorDialog(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fShell);
                    dialog.setRGB(colorSetting.getBackgroundRGB());
                    dialog.setText(Messages.ColorsView_BackgroundDialogText);
                    dialog.open();
                    RGB rgb = dialog.getRGB();
                    if (rgb != null) {
                        colorSetting.setBackgroundRGB(rgb);
                        ColorSettingsManager.setColorSettings(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
                        labelComposite.setBackground(colorSetting.getBackgroundColor());
                        label.setBackground(colorSetting.getBackgroundColor());
                    }
                }
            });
            Button tickButton = new Button((Composite)this, 8);
            tickButton.setText(Messages.ColorsView_TickButtonText);
            tickButton.setSize(tickButton.computeSize(-1, 19));
            tickButton.setBackground(Display.getDefault().getSystemColor(25));
            Canvas tickCanvas = new Canvas((Composite)this, 0);
            GridData gd = new GridData(0x1000000, 4, false, false);
            gd.widthHint = 12;
            gd.heightHint = bgButton.getSize().y;
            tickCanvas.setLayoutData((Object)gd);
            tickCanvas.setBackground(ColorsView.this.traceColorScheme.getBkColor(false, false, false));
            tickCanvas.addPaintListener(e -> {
                Rectangle bounds = tickCanvas.getBounds();
                e.gc.setForeground(ColorsView.this.traceColorScheme.getColor(61));
                int midy = bounds.y + bounds.height / 2 - 1;
                e.gc.drawLine(e.x, midy, e.x + e.width, midy);
                Rectangle rect = new Rectangle(e.x + 1, bounds.y + 2, 0, bounds.height - 6);
                int i = 1;
                while (i <= 3) {
                    rect.x += i;
                    rect.width = i++;
                    e.gc.setBackground(this.fColorSetting.getTickColor());
                    e.gc.fillRectangle(rect);
                }
            });
            tickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fSelectedRow = ColorSettingRow.this;
                    ColorDialog dialog = new ColorDialog(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fShell);
                    dialog.setRGB(colorSetting.getTickColorRGB());
                    dialog.setText(Messages.TickColorDialog_TickColorDialogTitle);
                    dialog.open();
                    RGB rgb = dialog.getRGB();
                    if (rgb != null) {
                        colorSetting.setTickColorRGB(rgb);
                        ColorSettingsManager.setColorSettings(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
                        ColorsView.this.refresh();
                    }
                }
            });
            Button filterButton = new Button((Composite)this, 8);
            filterButton.setText(Messages.ColorsView_FilterButtonText);
            filterButton.setBackground(Display.getDefault().getSystemColor(25));
            final Label filterText = new Label((Composite)this, 0);
            ITmfFilterTreeNode filter = colorSetting.getFilter();
            if (filter != null) {
                filterText.setText(filter.toString());
                filterText.setToolTipText(filter.toString());
            }
            filterText.setBackground(Display.getDefault().getSystemColor(25));
            filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fSelectedRow = ColorSettingRow.this;
                    ColorsView.this.refresh();
                    FilterDialog dialog = new FilterDialog(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fShell);
                    dialog.setFilter(colorSetting.getFilter());
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        if (dialog.getFilter() != null) {
                            colorSetting.setFilter(dialog.getFilter());
                            filterText.setText(dialog.getFilter().toString());
                            filterText.setToolTipText(dialog.getFilter().toString());
                        } else {
                            colorSetting.setFilter(null);
                            filterText.setText("");
                            filterText.setToolTipText("");
                        }
                        ColorSettingsManager.setColorSettings(((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
                        ColorsView.this.refresh();
                    }
                }
            });
            this.addPaintListener(e -> {
                if (ColorsView.this.fSelectedRow == this) {
                    Color borderColor = Display.getDefault().getSystemColor(2);
                    Point p = this.getSize();
                    Rectangle rect = new Rectangle(0, 0, p.x - 1, p.y - 1);
                    GC gc = e.gc;
                    gc.setForeground(borderColor);
                    gc.drawRectangle(rect);
                }
            });
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ((ColorSettingRow)ColorSettingRow.this).ColorsView.this.fSelectedRow = ColorSettingRow.this;
                    ColorsView.this.refresh();
                }
            };
            this.addMouseListener((MouseListener)mouseListener);
            label.addMouseListener((MouseListener)mouseListener);
            tickCanvas.addMouseListener((MouseListener)mouseListener);
            filterText.addMouseListener((MouseListener)mouseListener);
        }

        public ColorSetting getColorSetting() {
            return this.fColorSetting;
        }
    }

    private class DeleteAction
    extends Action {
        private DeleteAction() {
        }

        public void run() {
            if (ColorsView.this.fSelectedRow != null) {
                int index = ColorsView.this.fColorSettings.indexOf(ColorsView.this.fSelectedRow.getColorSetting());
                ColorsView.this.fColorSettings.remove(index);
                ColorsView.this.fSelectedRow.fColorSetting.dispose();
                ColorsView.this.fSelectedRow.dispose();
                ColorsView.this.fSelectedRow = index < ColorsView.this.fColorSettings.size() ? (ColorSettingRow)ColorsView.this.fListComposite.getChildren()[index] : null;
                ColorsView.this.refresh();
                ColorSettingsManager.setColorSettings(ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
            }
        }
    }

    private class ExportAction
    extends Action {
        private ExportAction() {
        }

        public void run() {
            FileDialog fileDialog = TmfFileDialogFactory.create(ColorsView.this.fShell, 8192);
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            fileDialog.setOverwrite(true);
            String pathName = fileDialog.open();
            if (pathName != null) {
                ColorSettingsXML.save(pathName, ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
            }
        }
    }

    private class ImportAction
    extends Action {
        private ImportAction() {
        }

        public void run() {
            ColorSetting[] colorSettings;
            FileDialog fileDialog = TmfFileDialogFactory.create(ColorsView.this.fShell, 4096);
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            String pathName = fileDialog.open();
            if (pathName != null && (colorSettings = ColorSettingsXML.load(pathName)).length > 0) {
                int n;
                boolean overwrite;
                if (!ColorsView.this.fColorSettings.isEmpty() && (overwrite = MessageDialog.openQuestion((Shell)ColorsView.this.fShell, (String)Messages.ColorsView_ImportOverwriteDialogTitle, (String)(String.valueOf(Messages.ColorsView_ImportOverwriteDialogMessage1) + Messages.ColorsView_ImportOverwriteDialogMessage2)))) {
                    Control[] controlArray = ColorsView.this.fListComposite.getChildren();
                    int n2 = controlArray.length;
                    n = 0;
                    while (n < n2) {
                        Control control = controlArray[n];
                        if (control instanceof ColorSettingRow) {
                            ((ColorSettingRow)control).fColorSetting.dispose();
                            control.dispose();
                        }
                        ++n;
                    }
                    ColorsView.this.fColorSettings = new ArrayList<ColorSetting>();
                    ColorsView.this.fSelectedRow = null;
                }
                ColorSetting[] colorSettingArray = colorSettings;
                n = colorSettings.length;
                int n3 = 0;
                while (n3 < n) {
                    ColorSetting colorSetting = colorSettingArray[n3];
                    ColorSettingRow row = new ColorSettingRow(ColorsView.this.fListComposite, colorSetting);
                    if (ColorsView.this.fSelectedRow == null) {
                        ColorsView.this.fColorSettings.add(colorSetting);
                        row.moveAbove((Control)ColorsView.this.fFillerComposite);
                    } else {
                        ColorsView.this.fColorSettings.add(ColorsView.this.fColorSettings.indexOf(ColorsView.this.fSelectedRow.getColorSetting()), colorSetting);
                        row.moveAbove((Control)ColorsView.this.fSelectedRow);
                    }
                    ++n3;
                }
                ColorsView.this.refresh();
                ColorSettingsManager.setColorSettings(ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
            }
        }
    }

    private class MoveDownAction
    extends Action {
        private MoveDownAction() {
        }

        public void run() {
            int index;
            if (ColorsView.this.fSelectedRow != null && (index = ColorsView.this.fColorSettings.indexOf(ColorsView.this.fSelectedRow.getColorSetting())) < ColorsView.this.fColorSettings.size() - 1) {
                ColorsView.this.fColorSettings.add(index + 1, ColorsView.this.fColorSettings.remove(index));
                ColorsView.this.fSelectedRow.moveBelow(ColorsView.this.fListComposite.getChildren()[index + 1]);
                ColorsView.this.refresh();
                ColorSettingsManager.setColorSettings(ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
            }
        }
    }

    private class MoveUpAction
    extends Action {
        private MoveUpAction() {
        }

        public void run() {
            int index;
            if (ColorsView.this.fSelectedRow != null && (index = ColorsView.this.fColorSettings.indexOf(ColorsView.this.fSelectedRow.getColorSetting())) > 0) {
                ColorsView.this.fColorSettings.add(index - 1, ColorsView.this.fColorSettings.remove(index));
                ColorsView.this.fSelectedRow.moveAbove(ColorsView.this.fListComposite.getChildren()[index - 1]);
                ColorsView.this.refresh();
                ColorSettingsManager.setColorSettings(ColorsView.this.fColorSettings.toArray(new ColorSetting[0]));
            }
        }
    }
}

