/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.encoding.HTVarInt;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class BasicSegment
implements ISegment {
    public static final IHTIntervalReader<BasicSegment> BASIC_SEGMENT_READ_FACTORY = buffer -> {
        long start = buffer.getLong();
        return new BasicSegment(start, start + HTVarInt.readLong((ISafeByteBufferReader)buffer));
    };
    private static final long serialVersionUID = -3257452887960883177L;
    private final long fStart;
    private final long fDuration;

    public BasicSegment(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        this.fStart = start;
        this.fDuration = end - start;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fStart + this.fDuration;
    }

    @Override
    public int getSizeOnDisk() {
        return HTVarInt.getEncodedLengthLong((long)this.fDuration) + 8;
    }

    @Override
    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.getStart());
        HTVarInt.writeLong((ISafeByteBufferWriter)buffer, (long)this.fDuration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.fStart);
        sb.append(", ");
        sb.append(this.fStart + this.fDuration);
        sb.append(']');
        return sb.toString();
    }
}

