/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.search.core.text.TextSearchScope;

public class FilesOfScopeCalculator
implements IResourceProxyVisitor {
    private final TextSearchScope fScope;
    private final MultiStatus fStatus;
    private ArrayList<IResource> fFiles;

    public FilesOfScopeCalculator(TextSearchScope scope, MultiStatus status) {
        this.fScope = scope;
        this.fStatus = status;
    }

    public boolean visit(IResourceProxy proxy) {
        boolean inScope = this.fScope.contains(proxy);
        if (inScope && proxy.getType() == 1) {
            this.fFiles.add(proxy.requestResource());
        }
        return inScope;
    }

    public IFile[] process() {
        this.fFiles = new ArrayList();
        try {
            IResource[] roots;
            IResource[] iResourceArray = roots = this.fScope.getRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                try {
                    if (resource.isAccessible()) {
                        resource.accept((IResourceProxyVisitor)this, 0);
                    }
                }
                catch (CoreException ex) {
                    this.fStatus.add(ex.getStatus());
                }
                ++n2;
            }
            IFile[] iFileArray = this.fFiles.toArray(new IFile[this.fFiles.size()]);
            return iFileArray;
        }
        finally {
            this.fFiles = null;
        }
    }
}

