/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.junit.Assert;
import org.junit.Test;

public class NonNullUtilsTest {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testAnnotationsCheckNotNullContentsStream() {
        Stream a = new ArrayList().stream();
        Stream<@Nullable E> b = new ArrayList().stream();
        @Nullable Stream<E> c = new ArrayList().stream();
        @Nullable Stream<@Nullable E> d = new ArrayList().stream();
        Stream<@Nullable E> e = new ArrayList().stream();
        @NonNull Stream f = (Stream)NonNullUtils.checkNotNull(new ArrayList().stream());
        @NonNull @NonNull Stream g = (Stream)NonNullUtils.checkNotNull(new ArrayList().stream());
        @NonNull @NonNull Stream checkedA = NonNullUtils.checkNotNullContents(a);
        @NonNull @NonNull Stream checkedB = NonNullUtils.checkNotNullContents(b);
        @NonNull @NonNull Stream checkedC = NonNullUtils.checkNotNullContents(c);
        @NonNull @NonNull Stream checkedD = NonNullUtils.checkNotNullContents(d);
        @NonNull @NonNull Stream checkedE = NonNullUtils.checkNotNullContents(e);
        @NonNull @NonNull Stream checkedF = NonNullUtils.checkNotNullContents((Stream)f);
        @NonNull @NonNull Stream checkedG = NonNullUtils.checkNotNullContents((Stream)g);
        Assert.assertNotNull((Object)checkedA);
        Assert.assertNotNull((Object)checkedB);
        Assert.assertNotNull((Object)checkedC);
        Assert.assertNotNull((Object)checkedD);
        Assert.assertNotNull((Object)checkedE);
        Assert.assertNotNull((Object)checkedF);
        Assert.assertNotNull((Object)checkedG);
    }

    public void testAnnotationsCheckNotNullContentsArray() {
        Object[] a = new String[]{};
        @Nullable Object[] b = new String[]{};
        Object @Nullable [] c = new String[]{};
        @Nullable Object @Nullable [] d = new String[]{};
        @NonNull Object[] e = new String[]{};
        Object @NonNull [] f = new String[]{};
        @NonNull Object @NonNull [] g = new String[]{};
        @NonNull String @NonNull [] checkedA = (String[])NonNullUtils.checkNotNullContents((Object[])a);
        @NonNull String @NonNull [] checkedB = (String[])NonNullUtils.checkNotNullContents((Object[])b);
        @NonNull String @NonNull [] checkedC = (String[])NonNullUtils.checkNotNullContents((Object[])c);
        @NonNull String @NonNull [] checkedD = (String[])NonNullUtils.checkNotNullContents((Object[])d);
        @NonNull String @NonNull [] checkedE = (String[])NonNullUtils.checkNotNullContents((Object[])e);
        @NonNull String @NonNull [] checkedF = (String[])NonNullUtils.checkNotNullContents((Object[])f);
        @NonNull String @NonNull [] checkedG = (String[])NonNullUtils.checkNotNullContents((Object[])g);
        Assert.assertNotNull((Object)checkedA);
        Assert.assertNotNull((Object)checkedB);
        Assert.assertNotNull((Object)checkedC);
        Assert.assertNotNull((Object)checkedD);
        Assert.assertNotNull((Object)checkedE);
        Assert.assertNotNull((Object)checkedF);
        Assert.assertNotNull((Object)checkedG);
    }

    @Test
    public void testCheckContentsStream() {
        ArrayList<@Nullable String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        List<@NonNull T> out = NonNullUtils.checkNotNullContents(list.stream()).collect(Collectors.toList());
        Assert.assertEquals(list, out);
    }

    @Test(expected=NullPointerException.class)
    public void testCheckContentsStreamNullRef() {
        NonNullUtils.checkNotNullContents((Stream)null);
    }

    @Test(expected=NullPointerException.class)
    public void testCheckContentsStreamNullElement() {
        ArrayList<@Nullable String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add(null);
        list.add("d");
        NonNullUtils.checkNotNullContents(list.stream()).collect(Collectors.toList());
    }

    @Test
    public void testCheckContentsArray() {
        @Nullable Object[] array = new String[]{"a", "b", "c"};
        @NonNull Object[] out = (String[])NonNullUtils.checkNotNullContents((Object[])array);
        Assert.assertArrayEquals((Object[])array, (Object[])out);
    }

    @Test(expected=NullPointerException.class)
    public void testCheckContentsArrayNullRef() {
        NonNullUtils.checkNotNullContents((Object[])null);
    }

    @Test(expected=NullPointerException.class)
    public void testCheckContentsArrayNullElement() {
        @Nullable Object[] array = new String[]{"a", null, "c"};
        NonNullUtils.checkNotNullContents((Object[])array);
    }
}

