/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views;

import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.junit.Assert;
import org.junit.Test;

public class FormatTimeUtilsTest {
    @Test
    public void testFormatTimeCalendar() {
        String calendarTime = FormatTimeUtils.formatTime((long)37935447675L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertTrue((boolean)calendarTime.endsWith("37.935447675"));
    }

    @Test
    public void testFormatTimeRelative() {
        String relativeNs = FormatTimeUtils.formatTime((long)5L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.RELATIVE, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"0.000000005s (5 ns)", (Object)relativeNs);
        String relativeUs = FormatTimeUtils.formatTime((long)15000L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.RELATIVE, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"0.000015000s (15 \u00b5s)", (Object)relativeUs);
        String relativeMs = FormatTimeUtils.formatTime((long)250000000L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.RELATIVE, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"0.250000000s (250 ms)", (Object)relativeMs);
        String relativeSeconds = FormatTimeUtils.formatTime((long)3123456000L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.RELATIVE, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"3.123456000s", (Object)relativeSeconds);
        String relativeMinutes = FormatTimeUtils.formatTime((long)120000000000L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.RELATIVE, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"120.000000000s", (Object)relativeMinutes);
        relativeMinutes = FormatTimeUtils.formatTime((long)138000000000L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.RELATIVE, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"138.000000000s", (Object)relativeMinutes);
        String relativeHours = FormatTimeUtils.formatTime((long)3600000000000L, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.RELATIVE, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"3600.000000000s", (Object)relativeHours);
    }
}

