/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.parsers.custom;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCustomTraceExtensionTest {
    protected abstract String getExtensionId();

    protected abstract String getTestTracePath();

    @Test
    public void testTraceTypePresence() {
        Assert.assertNotNull((Object)TmfTraceType.getTraceType((String)this.getExtensionId()));
    }

    @Test
    public void testValidate() throws TmfTraceImportException {
        Predicate<TraceTypeHelper> predicateTracetypeIdEquals = t -> t.getTraceTypeId().equals(this.getExtensionId());
        @NonNull List traceTypes = TmfTraceType.selectTraceType((String)this.getTestTracePath(), (String)this.getExtensionId());
        String failureMessage = String.format("Could not find expected custom trace type %s in extensions", this.getExtensionId());
        Assert.assertTrue((String)failureMessage, (boolean)traceTypes.stream().anyMatch(predicateTracetypeIdEquals));
    }
}

