/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.file;

import java.io.IOException;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapFileReadTest {
    @Test
    public void FileReadTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_UDP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile file = trace.getTrace();){
            PcapPacket packet = file.parseNextPacket();
            if (packet == null) {
                Assert.fail((String)"FileReadTest() failed!");
                return;
            }
            Assert.assertEquals((long)1L, (long)file.getCurrentRank());
            Assert.assertEquals((Object)file, (Object)packet.getPcapFile());
            Assert.assertEquals((Object)PcapProtocol.PCAP, (Object)packet.getProtocol());
            Assert.assertEquals((long)0L, (long)packet.getIndex());
            Assert.assertEquals((long)1120469540839312L, (long)packet.getTimestamp());
            Assert.assertEquals((long)92L, (long)packet.getOriginalLength());
            Assert.assertEquals((long)92L, (long)packet.getIncludedLength());
            Assert.assertEquals((Object)false, (Object)packet.isTruncated());
            Assert.assertEquals((Object)true, (Object)packet.validate());
            if (!packet.hasProtocol(PcapProtocol.ETHERNET_II)) {
                Assert.fail((String)"Packet doesn't have ethernet!");
            }
            if (!packet.hasProtocol(PcapProtocol.IPV4)) {
                Assert.fail((String)"Packet doesn't have IPv4!");
            }
            if (!packet.hasProtocol(PcapProtocol.UDP)) {
                Assert.fail((String)"Packet doesn't have UDP!");
            }
            if (!packet.hasProtocol(PcapProtocol.UNKNOWN)) {
                Assert.fail((String)"Packet doesn't have payload!");
            }
            file.seekPacket(58L);
            packet = file.parseNextPacket();
            if (packet == null) {
                Assert.fail((String)"FileReadTest() failed!");
                return;
            }
            Assert.assertEquals((Object)file, (Object)packet.getPcapFile());
            Assert.assertEquals((Object)PcapProtocol.PCAP, (Object)packet.getProtocol());
            Assert.assertEquals((long)58L, (long)packet.getIndex());
            Assert.assertEquals((long)1120469635045415L, (long)packet.getTimestamp());
            Assert.assertEquals((long)113L, (long)packet.getOriginalLength());
            Assert.assertEquals((long)113L, (long)packet.getIncludedLength());
            Assert.assertEquals((Object)false, (Object)packet.isTruncated());
            Assert.assertEquals((Object)true, (Object)packet.validate());
            if (!packet.hasProtocol(PcapProtocol.ETHERNET_II)) {
                Assert.fail((String)"Packet doesn't have ethernet!");
            }
            if (!packet.hasProtocol(PcapProtocol.IPV4)) {
                Assert.fail((String)"Packet doesn't have IPv4!");
            }
            if (!packet.hasProtocol(PcapProtocol.TCP)) {
                Assert.fail((String)"Packet doesn't have TCP!");
            }
            if (!packet.hasProtocol(PcapProtocol.UNKNOWN)) {
                Assert.fail((String)"Packet doesn't have payload!");
            }
            file.skipNextPacket();
            Assert.assertEquals((long)60L, (long)file.getCurrentRank());
            file.seekPacket(99999999L);
            Assert.assertEquals((long)647L, (long)file.getCurrentRank());
            file.skipNextPacket();
            Assert.assertEquals((long)647L, (long)file.getCurrentRank());
            packet = file.parseNextPacket();
            Assert.assertNull((Object)packet);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

