/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.file;

import java.io.IOException;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapOldFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapFileOpenTest {
    @Test
    public void FileOpenEmptyTest() throws IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.EMPTY_PCAP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapOldFile file = (PcapOldFile)trace.getTrace();){
            Assert.assertEquals((Object)PcapTestTrace.EMPTY_PCAP.getPath(), (Object)file.getPath());
            Assert.assertEquals((long)2L, (long)file.getMajorVersion());
            Assert.assertEquals((long)4L, (long)file.getMinorVersion());
            Assert.assertEquals((long)1L, (long)file.getDataLinkType());
            Assert.assertEquals((long)65535L, (long)file.getSnapShotLength());
            Assert.assertEquals((long)0L, (long)file.getTimeAccuracy());
            Assert.assertEquals((long)0L, (long)file.getTimeZoneCorrection());
            Assert.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)file.getByteOrder());
            Assert.assertEquals((long)0L, (long)file.getTotalNbPackets());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void FileOpenTest() throws IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapOldFile file = (PcapOldFile)trace.getTrace();){
            Assert.assertEquals((Object)PcapTestTrace.MOSTLY_TCP.getPath(), (Object)file.getPath());
            Assert.assertEquals((long)2L, (long)file.getMajorVersion());
            Assert.assertEquals((long)4L, (long)file.getMinorVersion());
            Assert.assertEquals((long)1L, (long)file.getDataLinkType());
            Assert.assertEquals((long)65535L, (long)file.getSnapShotLength());
            Assert.assertEquals((long)0L, (long)file.getTimeAccuracy());
            Assert.assertEquals((long)0L, (long)file.getTimeZoneCorrection());
            Assert.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)file.getByteOrder());
            Assert.assertEquals((long)43L, (long)file.getTotalNbPackets());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

