/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree;

import java.io.PrintStream;
import java.nio.channels.ClosedChannelException;
import org.eclipse.tracecompass.datastore.core.interval.HTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.junit.Assert;

public class HtTestUtils {
    public static final int BLOCKSIZE = 4096;
    public static final IHTIntervalReader<HTInterval> READ_FACTORY = HTInterval.INTERVAL_READER;

    private HtTestUtils() {
    }

    public static final <E extends IHTInterval, N extends HTNode<E>> void assertTreeIntegrity(AbstractHistoryTree<E, N> tree) {
        try {
            int i = 0;
            while (i < tree.getNodeCount()) {
                HtTestUtils.assertNodeIntegrity(tree, tree.getNode(i));
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static <E extends IHTInterval, N extends HTNode<E>> void assertNodeIntegrity(AbstractHistoryTree<E, N> tree, N node) {
        if (node.getNodeType() == IHTNode.NodeType.CORE) {
            HtTestUtils.assertChildrenIntegrity(tree, node);
        }
        for (IHTInterval object : node.getIntervals()) {
            Assert.assertTrue((String)String.format("Object start (%d) >= node start (%d)", object.getStart(), node.getNodeStart()), (object.getStart() >= node.getNodeStart() ? 1 : 0) != 0);
            Assert.assertTrue((String)String.format("Object start (%d) <= node end (%d)", object.getStart(), node.getNodeEnd()), (object.getStart() <= node.getNodeEnd() ? 1 : 0) != 0);
            Assert.assertTrue((String)String.format("Object end (%d) >= node start (%d)", object.getEnd(), node.getNodeStart()), (object.getEnd() >= node.getNodeStart() ? 1 : 0) != 0);
            Assert.assertTrue((String)String.format("Object end (%d) <= node end (%d)", object.getEnd(), node.getNodeEnd()), (object.getEnd() <= node.getNodeEnd() ? 1 : 0) != 0);
        }
    }

    private static <E extends IHTInterval, N extends HTNode<E>> void assertChildrenIntegrity(AbstractHistoryTree<E, N> tree, N node) {
        try {
            if (node.getNbChildren() > 0) {
                HTNode childNode = tree.getNode(node.getChild(0));
                Assert.assertEquals((String)("Equals start time of parent " + node.getSequenceNumber() + " and first child " + childNode.getSequenceNumber()), (long)node.getNodeStart(), (long)childNode.getNodeStart());
                if (node.isOnDisk()) {
                    childNode = tree.getNode(node.getLatestChild());
                    Assert.assertEquals((String)("Equals end time of parent " + node.getSequenceNumber() + " and last child " + childNode.getSequenceNumber()), (long)node.getNodeEnd(), (long)childNode.getNodeEnd());
                }
            }
            int i = 0;
            while (i < node.getNbChildren()) {
                HTNode childNode = tree.getNode(node.getChild(i));
                Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " has valid start time"), (node.getNodeStart() <= childNode.getNodeStart() ? 1 : 0) != 0);
                if (node.isOnDisk() && childNode.isOnDisk()) {
                    Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " has valid end time"), (childNode.getNodeEnd() <= node.getNodeEnd() ? 1 : 0) != 0);
                }
                Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " specific children"), (boolean)tree.verifyChildrenSpecific(node, i, childNode));
                Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " intersecting children"), (boolean)tree.verifyIntersectingChildren(node, childNode));
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static <E extends IHTInterval, N extends HTNode<E>> void debugPrintFullTree(PrintStream writer, AbstractHistoryTree<E, N> tree, boolean printIntervals, long ts) {
        HtTestUtils.preOrderPrint(writer, tree, false, (HTNode)tree.getLatestBranch().get(0), 0, ts);
        if (printIntervals) {
            HtTestUtils.preOrderPrint(writer, tree, true, (HTNode)tree.getLatestBranch().get(0), 0, ts);
        }
        writer.println('\n');
    }

    private static <E extends IHTInterval, N extends HTNode<E>> void preOrderPrint(PrintStream writer, AbstractHistoryTree<E, N> tree, boolean printIntervals, N node, int curDepth, long ts) {
        writer.println(node.toString());
        if (printIntervals && (ts <= 0L || ts >= node.getNodeStart() && ts <= node.getNodeEnd())) {
            node.debugPrintIntervals(writer);
        }
        switch (node.getNodeType()) {
            case LEAF: {
                return;
            }
            case CORE: {
                try {
                    int i = 0;
                    while (i < node.getNbChildren()) {
                        HTNode nextNode = tree.readNode(node.getChild(i));
                        int j = 0;
                        while (j < curDepth) {
                            writer.print("  ");
                            ++j;
                        }
                        writer.print("+-");
                        HtTestUtils.preOrderPrint(writer, tree, printIntervals, nextNode, curDepth + 1, ts);
                        ++i;
                    }
                    break;
                }
                catch (ClosedChannelException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

