/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.datastore.core.condition.ArrayTimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.junit.Assert;
import org.junit.Test;

public class DiscreteTimeRangeConditionTest {
    private static final long LOW = 0L;
    private static final long HIGH = 10L;
    private static final List<Long> VALUES = Arrays.asList(0L, 5L, 10L);
    private static final TimeRangeCondition CONDITION = new ArrayTimeRangeCondition(VALUES);

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor() {
        new ArrayTimeRangeCondition(Collections.emptyList());
    }

    @Test
    public void testBounds() {
        Assert.assertEquals((long)0L, (long)CONDITION.min());
        Assert.assertEquals((long)10L, (long)CONDITION.max());
    }

    @Test
    public void testPredicate() {
        Assert.assertFalse((boolean)CONDITION.test(-5L));
        for (Long v : VALUES) {
            Assert.assertTrue((boolean)CONDITION.test(v.longValue()));
            Assert.assertFalse((boolean)CONDITION.test(v + 1L));
        }
        Assert.assertFalse((boolean)CONDITION.test(15L));
    }

    @Test
    public void testPredicateAndAdd() {
        ArrayList<Long> values = new ArrayList<Long>();
        values.add(1L);
        values.add(5L);
        ArrayTimeRangeCondition condition = new ArrayTimeRangeCondition(values);
        Assert.assertFalse((boolean)condition.test(-5L));
        for (Long v : values) {
            Assert.assertTrue((boolean)condition.test(v.longValue()));
            Assert.assertFalse((boolean)condition.test(v + 1L));
        }
        Assert.assertFalse((boolean)condition.test(15L));
        values.add(15L);
        Assert.assertFalse((boolean)condition.test(15L));
    }

    @Test
    public void testIntersects() {
        Assert.assertFalse((boolean)CONDITION.intersects(Long.MIN_VALUE, -1L));
        Assert.assertTrue((boolean)CONDITION.intersects(0L, 4L));
        Assert.assertFalse((boolean)CONDITION.intersects(1L, 4L));
        Assert.assertTrue((boolean)CONDITION.intersects(2L, 8L));
        Assert.assertFalse((boolean)CONDITION.intersects(6L, 9L));
        Assert.assertTrue((boolean)CONDITION.intersects(5L, 15L));
        Assert.assertFalse((boolean)CONDITION.intersects(11L, Long.MAX_VALUE));
    }

    @Test
    public void testSubCondition() {
        @Nullable TimeRangeCondition sub = CONDITION.subCondition(-5L, 8L);
        Assert.assertNotNull((Object)sub);
        Assert.assertEquals(ArrayTimeRangeCondition.class, sub.getClass());
        long low = sub.min();
        long high = sub.max();
        Assert.assertEquals((long)0L, (long)low);
        Assert.assertEquals((long)5L, (long)high);
        sub = CONDITION.subCondition(1L, 4L);
        Assert.assertNull((Object)sub);
        sub = CONDITION.subCondition(0L, 5L);
        Assert.assertNotNull((Object)sub);
        low = sub.min();
        high = sub.max();
        Assert.assertEquals((long)0L, (long)low);
        Assert.assertEquals((long)5L, (long)high);
    }
}

