/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.sac;

import java.util.Stack;
import org.eclipse.e4.ui.css.core.dom.CSSProperty;
import org.eclipse.e4.ui.css.core.impl.dom.CSSImportRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPageRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPropertyImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSRuleListImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleDeclarationImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleSheetImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSUnknownRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueFactory;
import org.eclipse.e4.ui.css.core.impl.dom.MediaListImpl;
import org.eclipse.e4.ui.css.core.sac.ExtendedDocumentHandler;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSDocumentHandlerImpl
implements ExtendedDocumentHandler {
    private Stack<Object> nodeStack;
    private Object nodeRoot;
    private CSSStyleSheet parentStyleSheet;
    private boolean ignore;

    public Object getRoot() {
        return this.nodeRoot;
    }

    public void startDocument(InputSource source) throws CSSException {
        if (this.getNodeStack().empty()) {
            CSSStyleSheetImpl styleSheet = new CSSStyleSheetImpl();
            this.parentStyleSheet = styleSheet;
            CSSRuleListImpl rules = new CSSRuleListImpl();
            styleSheet.setRuleList(rules);
            this.getNodeStack().push(styleSheet);
            this.getNodeStack().push(rules);
        }
    }

    public void endDocument(InputSource source) throws CSSException {
        this.getNodeStack().pop();
        this.nodeRoot = this.getNodeStack().pop();
    }

    public void comment(String text) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        CSSUnknownRuleImpl ir = new CSSUnknownRuleImpl(this.parentStyleSheet, null, atRule);
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(ir);
        } else {
            this.nodeRoot = ir;
        }
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        CSSImportRuleImpl ir = new CSSImportRuleImpl(this.parentStyleSheet, null, uri, new MediaListImpl(media));
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(ir);
        } else {
            this.nodeRoot = ir;
        }
    }

    public void startMedia(SACMediaList media) throws CSSException {
        this.ignore = true;
    }

    public void endMedia(SACMediaList media) throws CSSException {
        this.ignore = false;
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
        CSSPageRuleImpl pageRule = new CSSPageRuleImpl(this.parentStyleSheet, null, name, pseudo_page);
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(pageRule);
        }
        CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(pageRule);
        pageRule.setStyle(decl);
        this.getNodeStack().push(pageRule);
        this.getNodeStack().push(decl);
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
        this.getNodeStack().pop();
        this.nodeRoot = this.getNodeStack().pop();
    }

    public void startFontFace() throws CSSException {
        this.ignore = true;
    }

    public void endFontFace() throws CSSException {
        this.ignore = false;
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        CSSStyleRuleImpl rule = new CSSStyleRuleImpl(this.parentStyleSheet, null, selectors);
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(rule);
        }
        CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(rule);
        rule.setStyle(decl);
        this.getNodeStack().push(rule);
        this.getNodeStack().push(decl);
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        this.getNodeStack().pop();
        this.nodeRoot = this.getNodeStack().pop();
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        if (!this.ignore) {
            CSSStyleDeclarationImpl decl = (CSSStyleDeclarationImpl)this.getNodeStack().peek();
            decl.addProperty(this.getCSSProperty(decl, name, value, important));
        }
    }

    protected CSSProperty getCSSProperty(CSSStyleDeclaration styleDeclaration, String name, LexicalUnit value, boolean important) {
        return new CSSPropertyImpl(name, CSSValueFactory.newValue(value), important);
    }

    @Override
    public Object getNodeRoot() {
        return this.nodeRoot;
    }

    @Override
    public void setNodeStack(Stack<Object> nodeStack) {
        this.nodeStack = nodeStack;
    }

    public Stack<Object> getNodeStack() {
        if (this.nodeStack == null) {
            this.nodeStack = new Stack();
        }
        return this.nodeStack;
    }
}

