/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.SortedProperties;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferences
extends EclipsePreferences {
    static final String PREFS_REGULAR_QUALIFIER = "org.eclipse.core.resources";
    static final String PREFS_DERIVED_QUALIFIER = "org.eclipse.core.resources.derived";
    static final String PLACEHOLDER = "<temporary_value_placeholder>";
    private static final Set<String> loadedNodes = ConcurrentHashMap.newKeySet();
    private IFile file;
    private volatile boolean initialized;
    private volatile boolean isReading;
    private volatile boolean isWriting;
    private IEclipsePreferences loadLevel;
    private final IProject project;
    private final String qualifier;
    private final int segmentCount;
    private volatile Workspace workspace;

    static void deleted(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        int count = path.segmentCount();
        if (count != 3) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        ProjectPreferences projectNode = (ProjectPreferences)root.node("project").node(project);
        try {
            if (!projectNode.nodeExists(qualifier)) {
                return;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        ProjectPreferences.clearNode(projectNode.node(qualifier));
        if (qualifier.equals(PREFS_REGULAR_QUALIFIER) || qualifier.equals(PREFS_DERIVED_QUALIFIER)) {
            ProjectPreferences.preferencesChanged(file.getProject());
        }
    }

    static void deleted(IFolder folder) throws CoreException {
        IPath path = folder.getFullPath();
        int count = path.segmentCount();
        if (count != 2) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        Preferences projectNode = root.node("project").node(project);
        boolean hasResourcesSettings = ProjectPreferences.getFile(folder, PREFS_REGULAR_QUALIFIER).exists() || ProjectPreferences.getFile(folder, PREFS_DERIVED_QUALIFIER).exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ProjectPreferences.preferencesChanged(folder.getProject());
        }
    }

    static void deleted(IProject project) throws CoreException {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences projectNode = root.node("project").node(project.getName());
        boolean hasResourcesSettings = ProjectPreferences.getFile(project, PREFS_REGULAR_QUALIFIER).exists() || ProjectPreferences.getFile(project, PREFS_DERIVED_QUALIFIER).exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ProjectPreferences.preferencesChanged(project);
        }
    }

    static void deleted(IResource resource) throws CoreException {
        switch (resource.getType()) {
            case 1: {
                ProjectPreferences.deleted((IFile)resource);
                return;
            }
            case 2: {
                ProjectPreferences.deleted((IFolder)resource);
                return;
            }
            case 4: {
                ProjectPreferences.deleted((IProject)resource);
                return;
            }
        }
    }

    static IFile getFile(IFolder folder, String qualifier) {
        Assert.isLegal((boolean)folder.getName().equals(".settings"));
        return folder.getFile(IPath.fromOSString((String)qualifier).addFileExtension("prefs"));
    }

    static IFile getFile(IProject project, String qualifier) {
        return project.getFile(IPath.fromOSString((String)".settings").append(qualifier).addFileExtension("prefs"));
    }

    private static Properties loadProperties(IFile file) throws BackingStoreException {
        if (Policy.DEBUG_PREFERENCES) {
            Policy.debug("Loading preferences from file: " + String.valueOf(file.getFullPath()));
        }
        Properties result = new Properties();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedInputStream input = new BufferedInputStream(file.getContents(true));){
                result.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug(MessageFormat.format("Preference file {0} does not exist.", file.getFullPath()));
                }
            }
            String message = NLS.bind((String)Messages.preferences_loadException, (Object)file.getFullPath());
            ProjectPreferences.log((IStatus)new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e));
            throw new BackingStoreException(message);
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.preferences_loadException, (Object)file.getFullPath());
            ProjectPreferences.log((IStatus)new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e));
            throw new BackingStoreException(message);
        }
        return result;
    }

    private static void preferencesChanged(IProject project) {
        Workspace workspace = (Workspace)project.getWorkspace();
        workspace.getCharsetManager().projectPreferencesChanged(project);
        workspace.getContentDescriptionManager().projectPreferencesChanged(project);
    }

    private static void read(ProjectPreferences node, IFile file) throws BackingStoreException, CoreException {
        if (file == null || !file.exists()) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Unable to determine preference file or file does not exist for node: " + node.absolutePath());
            }
            return;
        }
        ExportedPreferences myNode = ProjectPreferences.overridingPreferences(node, file);
        boolean oldIsReading = node.isReading;
        node.isReading = true;
        try {
            Platform.getPreferencesService().applyPreferences((IExportedPreferences)myNode);
        }
        finally {
            node.isReading = oldIsReading;
        }
    }

    private static ExportedPreferences overridingPreferences(ProjectPreferences current, IFile file) throws BackingStoreException {
        Properties fromDisk = ProjectPreferences.loadProperties(file);
        Properties fromMemory = new Properties();
        current.convertToProperties(fromMemory, "");
        Set<Map.Entry<Object, Object>> set = fromMemory.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = (String)entry.getKey();
            if (fromDisk.containsKey(key) || key.indexOf(47) <= 0) continue;
            fromDisk.put(key, PLACEHOLDER);
        }
        ExportedPreferences myNode = (ExportedPreferences)ExportedPreferences.newRoot().node(current.absolutePath());
        ProjectPreferences.convertFromProperties((EclipsePreferences)myNode, (Properties)fromDisk, (boolean)false);
        myNode.accept(child -> {
            String[] keys = child.keys();
            boolean nodeShouldBeRemoved = false;
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (PLACEHOLDER.equals(child.get(key, null))) {
                    child.remove(key);
                    nodeShouldBeRemoved = true;
                }
                ++n2;
            }
            if (child != myNode && nodeShouldBeRemoved) {
                ((ExportedPreferences)child).setExportRoot();
            }
            return true;
        });
        return myNode;
    }

    static void removeNode(Preferences node) throws CoreException {
        String message = NLS.bind((String)Messages.preferences_removeNodeException, (Object)node.absolutePath());
        try {
            node.removeNode();
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        ProjectPreferences.removeLoadedNodes(node);
    }

    static void clearNode(Preferences node) throws CoreException {
        try {
            ProjectPreferences.clearAll(node);
        }
        catch (BackingStoreException e) {
            String message = NLS.bind((String)Messages.preferences_clearNodeException, (Object)node.absolutePath());
            Status status = new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        ProjectPreferences.removeLoadedNodes(node);
    }

    private static void clearAll(Preferences node) throws BackingStoreException {
        String[] names;
        node.clear();
        String[] stringArray = names = node.childrenNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            ProjectPreferences.clearAll(node.node(name2));
            ++n2;
        }
    }

    private static void removeLoadedNodes(Preferences node) {
        String path = node.absolutePath();
        loadedNodes.removeIf(key -> key.startsWith(path));
    }

    /*
     * WARNING - void declaration
     */
    public static void updatePreferences(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        if (!"prefs".equals(path.getFileExtension())) {
            return;
        }
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences node = root.node("project").node(project).node(qualifier);
        String message = null;
        try {
            void projectPrefs;
            message = NLS.bind((String)Messages.preferences_syncException, (Object)node.absolutePath());
            if (!(node instanceof ProjectPreferences)) {
                return;
            }
            ProjectPreferences projectPreferences = (ProjectPreferences)node;
            if (projectPrefs.isWriting) {
                return;
            }
            ProjectPreferences.read((ProjectPreferences)projectPrefs, file);
            projectPrefs.dirty = false;
            if (PREFS_REGULAR_QUALIFIER.equals(qualifier) || PREFS_DERIVED_QUALIFIER.equals(qualifier)) {
                ProjectPreferences.preferencesChanged(file.getProject());
            }
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public ProjectPreferences() {
        super(null, null);
        this.qualifier = null;
        this.project = null;
        this.segmentCount = 0;
    }

    private ProjectPreferences(EclipsePreferences parent, String name, Workspace workspace) {
        super(parent, name);
        this.setWorkspace(workspace);
        String path = this.absolutePath();
        this.segmentCount = ProjectPreferences.getSegmentCount((String)path);
        if (this.segmentCount == 1) {
            this.qualifier = null;
            this.project = null;
            return;
        }
        String projectName = ProjectPreferences.getSegment((String)path, (int)1);
        this.project = projectName != null ? this.getWorkspace().getRoot().getProject(projectName) : null;
        this.qualifier = this.segmentCount > 2 ? ProjectPreferences.getSegment((String)path, (int)2).intern() : null;
    }

    public String[] childrenNames() throws BackingStoreException {
        this.checkRemoved();
        this.initialize();
        this.silentLoad();
        return super.childrenNames();
    }

    public void clear() {
        this.checkRemoved();
        this.silentLoad();
        super.clear();
    }

    private List<String> computeChildren() {
        if (this.project == null) {
            return List.of();
        }
        IFolder folder = this.project.getFolder(".settings");
        if (!folder.exists()) {
            return List.of();
        }
        IResource[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1 && "prefs".equals(resource.getFullPath().getFileExtension())) {
                result.add(resource.getFullPath().removeFileExtension().lastSegment());
            }
            ++n2;
        }
        return result;
    }

    public void flush() throws BackingStoreException {
        if (this.isReading) {
            return;
        }
        this.isWriting = true;
        try {
            IEclipsePreferences toFlush = super.internalFlush();
            if (toFlush != null) {
                toFlush.flush();
            }
        }
        finally {
            this.isWriting = false;
        }
    }

    private IFile getFile() {
        if (this.file == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            this.file = ProjectPreferences.getFile(this.project, this.qualifier);
        }
        return this.file;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            ProjectPreferences node = this;
            int i = 3;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected IPath getLocation() {
        if (this.project == null || this.qualifier == null) {
            return null;
        }
        IPath path = this.project.getLocation();
        return this.computeLocation(path, this.qualifier);
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new ProjectPreferences(nodeParent, nodeName, this.workspace);
    }

    protected String internalGet(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        this.silentLoad();
        return super.internalGet(key);
    }

    protected String internalPut(String key, String newValue) {
        this.checkRemoved();
        this.silentLoad();
        if (this.segmentCount == 3 && PREFS_REGULAR_QUALIFIER.equals(this.qualifier) && this.project != null && "separateDerivedEncodings".equals(key)) {
            CharsetManager charsetManager = this.getWorkspace().getCharsetManager();
            if (Boolean.parseBoolean(newValue)) {
                charsetManager.splitEncodingPreferences(this.project);
            } else {
                charsetManager.mergeEncodingPreferences(this.project);
            }
        }
        return super.internalPut(key, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.segmentCount != 2) {
            return;
        }
        if (this.initialized) {
            return;
        }
        if (this.project.isOpen()) {
            try {
                ProjectPreferences projectPreferences = this;
                synchronized (projectPreferences) {
                    Set<String> addedNames = Set.of(this.internalChildNames());
                    for (String child : this.computeChildren()) {
                        if (addedNames.contains(child)) continue;
                        this.addChild(child, null);
                    }
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    public String[] keys() {
        this.checkRemoved();
        this.silentLoad();
        return super.keys();
    }

    protected void load() throws BackingStoreException {
        this.load(true);
    }

    private void load(boolean reportProblems) throws BackingStoreException {
        block18: {
            IFile localFile = this.getFile();
            if (localFile == null || !localFile.exists()) {
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Unable to determine preference file or file does not exist for node: " + this.absolutePath());
                }
                return;
            }
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Loading preferences from file: " + String.valueOf(localFile.getFullPath()));
            }
            Properties fromDisk = new Properties();
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (InputStream input = localFile.getContents(true);){
                    fromDisk.load(input);
                    ProjectPreferences.convertFromProperties((EclipsePreferences)this, (Properties)fromDisk, (boolean)true);
                    loadedNodes.add(this.absolutePath());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 368) {
                    if (Policy.DEBUG_PREFERENCES) {
                        Policy.debug("Preference file does not exist for node: " + this.absolutePath());
                    }
                    return;
                }
                if (reportProblems) {
                    String message = NLS.bind((String)Messages.preferences_loadException, (Object)localFile.getFullPath());
                    ProjectPreferences.log((IStatus)new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
            }
            catch (IOException e) {
                if (!reportProblems) break block18;
                String message = NLS.bind((String)Messages.preferences_loadException, (Object)localFile.getFullPath());
                ProjectPreferences.log((IStatus)new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e));
                throw new BackingStoreException(message);
            }
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        if (path.length() == 0) {
            return !this.removed;
        }
        this.checkRemoved();
        this.initialize();
        this.silentLoad();
        if (this.segmentCount != 1) {
            return super.nodeExists(path);
        }
        if (path.length() == 0) {
            return super.nodeExists(path);
        }
        if (path.charAt(0) == '/') {
            return super.nodeExists(path);
        }
        if (path.indexOf(47) != -1) {
            return super.nodeExists(path);
        }
        return this.getWorkspace().getRoot().getProject(path).exists() || super.nodeExists(path);
    }

    public void remove(String key) {
        this.checkRemoved();
        this.silentLoad();
        super.remove(key);
        if (this.segmentCount == 3 && PREFS_REGULAR_QUALIFIER.equals(this.qualifier) && this.project != null && "separateDerivedEncodings".equals(key)) {
            CharsetManager charsetManager = this.getWorkspace().getCharsetManager();
            charsetManager.mergeEncodingPreferences(this.project);
        }
    }

    protected void save() throws BackingStoreException {
        IFile fileInWorkspace = this.getFile();
        if (fileInWorkspace == null) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Not saving preferences since there is no file for node: " + this.absolutePath());
            }
            return;
        }
        String finalQualifier = this.qualifier;
        BackingStoreException[] bse = new BackingStoreException[1];
        try {
            ICoreRunnable operation = monitor -> {
                try {
                    Properties table = this.convertToProperties((Properties)new SortedProperties(), "");
                    if (table.isEmpty()) {
                        if (fileInWorkspace.exists()) {
                            IStatus status1;
                            if (Policy.DEBUG_PREFERENCES) {
                                Policy.debug("Deleting preference file: " + String.valueOf(fileInWorkspace.getFullPath()));
                            }
                            if (fileInWorkspace.isReadOnly() && !(status1 = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                                throw new CoreException(status1);
                            }
                            try {
                                fileInWorkspace.delete(true, null);
                            }
                            catch (CoreException e1) {
                                String message1 = NLS.bind((String)Messages.preferences_deleteException, (Object)fileInWorkspace.getFullPath());
                                ProjectPreferences.log((IStatus)new Status(2, PREFS_REGULAR_QUALIFIER, 2, message1, null));
                            }
                        }
                        return;
                    }
                    table.put("eclipse.preferences.version", "1");
                    String s = ProjectPreferences.removeTimestampFromTable((Properties)table);
                    String systemLineSeparator = System.lineSeparator();
                    String fileLineSeparator = fileInWorkspace.getLineSeparator(true);
                    if (!systemLineSeparator.equals(fileLineSeparator)) {
                        s = s.replaceAll(systemLineSeparator, fileLineSeparator);
                    }
                    byte[] input = s.getBytes(StandardCharsets.UTF_8);
                    fileInWorkspace.getParent().refreshLocal(0, null);
                    fileInWorkspace.refreshLocal(0, null);
                    if (fileInWorkspace.exists()) {
                        IStatus status2;
                        if (Policy.DEBUG_PREFERENCES) {
                            Policy.debug("Setting preference file contents for: " + String.valueOf(fileInWorkspace.getFullPath()));
                        }
                        if (fileInWorkspace.isReadOnly() && !(status2 = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                            throw new CoreException(status2);
                        }
                        fileInWorkspace.setContents(input, 2, null);
                    } else {
                        IFolder folder = (IFolder)fileInWorkspace.getParent();
                        if (!folder.exists()) {
                            if (Policy.DEBUG_PREFERENCES) {
                                Policy.debug("Creating parent preference directory: " + String.valueOf(folder.getFullPath()));
                            }
                            folder.create(0, true, null);
                        }
                        if (Policy.DEBUG_PREFERENCES) {
                            Policy.debug("Creating preference file: " + String.valueOf(fileInWorkspace.getLocation()));
                        }
                        fileInWorkspace.create(input, 0, null);
                    }
                    if (PREFS_DERIVED_QUALIFIER.equals(finalQualifier)) {
                        fileInWorkspace.setDerived(true, null);
                    }
                }
                catch (BackingStoreException e2) {
                    backingStoreExceptionArray[0] = e2;
                }
                catch (IOException e3) {
                    String message2 = NLS.bind((String)Messages.preferences_saveProblems, (Object)fileInWorkspace.getFullPath());
                    ProjectPreferences.log((IStatus)new Status(4, PREFS_REGULAR_QUALIFIER, 4, message2, (Throwable)e3));
                    backingStoreExceptionArray[0] = new BackingStoreException(message2);
                }
            };
            try {
                Workspace ws = this.getWorkspace();
                if (ws.getWorkManager().isLockAlreadyAcquired()) {
                    operation.run(null);
                } else {
                    IResourceRuleFactory factory = ws.getRuleFactory();
                    ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{factory.deleteRule(fileInWorkspace), factory.createRule(fileInWorkspace.getParent()), factory.modifyRule(fileInWorkspace), factory.derivedRule(fileInWorkspace)});
                    ws.run(operation, rule, 0, null);
                    if (bse[0] != null) {
                        throw bse[0];
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw new BackingStoreException(Messages.preferences_operationCanceled);
            }
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.preferences_saveProblems, (Object)fileInWorkspace.getFullPath());
            ProjectPreferences.log((IStatus)new Status(4, PREFS_REGULAR_QUALIFIER, 4, message, (Throwable)e));
            throw new BackingStoreException(message);
        }
    }

    private void silentLoad() {
        ProjectPreferences node = (ProjectPreferences)this.getLoadLevel();
        if (node == null) {
            return;
        }
        if (this.isAlreadyLoaded((IEclipsePreferences)node) || node.isLoading()) {
            return;
        }
        try {
            try {
                node.setLoading(true);
                node.load(false);
            }
            catch (BackingStoreException backingStoreException) {
                node.setLoading(false);
            }
        }
        finally {
            node.setLoading(false);
        }
    }

    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private Workspace getWorkspace() {
        if (this.workspace != null) {
            return this.workspace;
        }
        return (Workspace)ResourcesPlugin.getWorkspace();
    }
}

