/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.synchronization;

import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfConstantTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class TsTransformFactoryTest {
    private final ITmfTimestamp t0 = TmfTimestamp.fromSeconds((long)0L);
    private final ITmfTimestamp t100 = TmfTimestamp.fromSeconds((long)100L);
    private final ITmfTimestamp t1e2 = TmfTimestamp.create((long)1L, (int)2);
    private final ITmfTimestamp t1e3 = TmfTimestamp.create((long)1L, (int)3);
    private final ITmfTimestamp tn0 = TmfTimestamp.fromNanos((long)0L);
    private final ITmfTimestamp tn100 = TmfTimestamp.fromNanos((long)100L);
    private final ITmfTimestamp tn1 = TmfTimestamp.fromNanos((long)1L);
    private final ITmfTimestampTransform identity1 = TimestampTransformFactory.createLinear((double)1.0, (ITmfTimestamp)TmfTimestamp.fromNanos((long)0L));
    private final ITmfTimestampTransform offset1 = TimestampTransformFactory.createWithOffset((long)100L);
    private final ITmfTimestampTransform offset2 = TimestampTransformFactory.createLinear((BigDecimal)BigDecimal.ONE, (BigDecimal)new BigDecimal(100));
    private final ITmfTimestampTransform offset3 = TimestampTransformFactory.createLinear((double)1.0, (long)100L);
    private final ITmfTimestampTransform offset4 = TimestampTransformFactory.createLinear((double)1.0, (ITmfTimestamp)TmfTimestamp.fromNanos((long)100L));

    @Test
    public void transformIdentity() {
        ITmfTimestampTransform identity = TimestampTransformFactory.createWithOffset((long)0L);
        TmfConstantTransform innefficientIdentity = new TmfConstantTransform();
        ITmfTimestampTransform compositeInnefficientIdentity = identity.composeWith((ITmfTimestampTransform)innefficientIdentity);
        ITmfTimestampTransform compositeInnefficientIdentity2 = innefficientIdentity.composeWith((ITmfTimestampTransform)innefficientIdentity);
        ITmfTimestampTransform compositeInnefficientIdentity3 = innefficientIdentity.composeWith(identity);
        Assert.assertEquals((Object)this.t0, (Object)identity.transform(this.t0));
        Assert.assertEquals((Object)this.tn0, (Object)identity.transform(this.tn0));
        Assert.assertEquals((Object)this.t100, (Object)identity.transform(this.t100));
        Assert.assertEquals((Object)this.t1e2, (Object)identity.transform(this.t100));
        Assert.assertEquals((Object)this.t1e2, (Object)identity.transform(this.t1e2));
        Assert.assertEquals((Object)this.t1e3, (Object)identity.transform(this.t1e3));
        Assert.assertEquals((Object)this.tn100, (Object)identity.transform(this.tn100));
        Assert.assertEquals((Object)this.t0, (Object)innefficientIdentity.transform(this.t0));
        Assert.assertEquals((Object)this.t0, (Object)compositeInnefficientIdentity.transform(this.t0));
        Assert.assertEquals((Object)this.t0, (Object)compositeInnefficientIdentity2.transform(this.t0));
        Assert.assertEquals((Object)this.t0, (Object)compositeInnefficientIdentity3.transform(this.t0));
    }

    @Test
    public void transformOffset() {
        ITmfTimestampTransform offset = this.offset1;
        ITmfTimestampTransform compositeTransform = offset.composeWith(TimestampTransformFactory.createWithOffset((ITmfTimestamp)TmfTimestamp.fromNanos((long)-100L)));
        Assert.assertEquals((Object)this.tn100, (Object)offset.transform(this.t0));
        Assert.assertEquals((Object)this.tn100, (Object)offset.transform(this.tn0));
        Assert.assertEquals((Object)this.tn0, (Object)compositeTransform.transform(this.tn0));
        Assert.assertEquals((Object)this.t0, (Object)compositeTransform.transform(this.t0));
        Assert.assertEquals((long)200L, (long)this.offset1.transform(100L));
        Assert.assertEquals((long)200L, (long)this.offset2.transform(100L));
        Assert.assertEquals((long)200L, (long)this.offset3.transform(100L));
        Assert.assertEquals((long)200L, (long)this.offset4.transform(100L));
    }

    @Test
    public void transformSlope() {
        ITmfTimestampTransform slope = TimestampTransformFactory.createLinear((double)10.0, (long)0L);
        ITmfTimestampTransform slope1 = TimestampTransformFactory.createLinear((double)10.0, (ITmfTimestamp)TmfTimestamp.fromNanos((long)0L));
        Assert.assertEquals((Object)this.t1e3, (Object)slope.transform(this.t1e2));
        Assert.assertEquals((Object)this.tn100, (Object)slope.transform(TmfTimestamp.fromNanos((long)10L)));
        Assert.assertEquals((Object)this.tn100, (Object)slope.transform(slope.transform(this.tn1)));
        Assert.assertEquals((Object)this.tn100, (Object)slope.composeWith(slope).transform(this.tn1));
        Assert.assertEquals((Object)this.tn100, (Object)slope1.transform(TmfTimestamp.fromNanos((long)10L)));
    }

    @Test
    public void testToString() {
        String expectedLinear = "TmfTimestampTransformLinearFast [ slope = 314.0, offset = 0.0 ]";
        String expectedLinearBigDec = "TmfTimestampTransformLinearFast [ slope = 314, offset = 0 ]";
        String expectedOffset = "TmfConstantTransform [ offset = 314 ]";
        String expectedIdentity = "TmfTimestampTransform [ IDENTITY ]";
        String expectedOffset100 = "TmfConstantTransform [ offset = 100 ]";
        Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 314.0, offset = 0.0 ]", (Object)TimestampTransformFactory.createLinear((double)314.0, (long)0L).toString());
        Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 314, offset = 0 ]", (Object)TimestampTransformFactory.createLinear((BigDecimal)BigDecimal.valueOf(314L), (BigDecimal)BigDecimal.ZERO).toString());
        Assert.assertEquals((Object)"TmfConstantTransform [ offset = 314 ]", (Object)TimestampTransformFactory.createLinear((double)1.0, (long)314L).toString());
        Assert.assertEquals((Object)"TmfConstantTransform [ offset = 314 ]", (Object)TimestampTransformFactory.createWithOffset((long)314L).toString());
        Assert.assertEquals((Object)"TmfConstantTransform [ offset = 314 ]", (Object)TimestampTransformFactory.createWithOffset((long)14L).composeWith(TimestampTransformFactory.createWithOffset((long)300L)).toString());
        Assert.assertEquals((Object)"TmfTimestampTransform [ IDENTITY ]", (Object)TimestampTransformFactory.createWithOffset((long)314L).composeWith(TimestampTransformFactory.createWithOffset((long)-314L)).toString());
        Assert.assertEquals((Object)"TmfTimestampTransform [ IDENTITY ]", (Object)TimestampTransformFactory.createWithOffset((long)0L).toString());
        Assert.assertEquals((Object)"TmfTimestampTransform [ IDENTITY ]", (Object)this.identity1.toString());
        Assert.assertEquals((Object)"TmfConstantTransform [ offset = 100 ]", (Object)this.offset1.toString());
        Assert.assertEquals((Object)"TmfConstantTransform [ offset = 100 ]", (Object)this.offset2.toString());
        Assert.assertEquals((Object)"TmfConstantTransform [ offset = 100 ]", (Object)this.offset3.toString());
        Assert.assertEquals((Object)"TmfConstantTransform [ offset = 100 ]", (Object)this.offset4.toString());
    }
}

