/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.core.tests.consumer;

import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.NumericalConsumer;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubChartProvider;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;
import org.junit.Assert;
import org.junit.Test;

public class NumericalConsumerTest {
    private final @NonNull StubChartProvider fProvider = new StubChartProvider();

    @Test
    public void testResolver() {
        IDataChartDescriptor<StubObject, ?> descriptor = this.fProvider.getDataDescriptor("Long");
        NumericalConsumer consumer = new NumericalConsumer((INumericalResolver)INumericalResolver.class.cast(descriptor.getResolver()));
        StubObject obj = new StubObject("str", 1, 10L, 10.0);
        Assert.assertTrue((boolean)consumer.test((Object)obj));
        consumer.accept((Object)obj);
        Assert.assertEquals((Object)10L, consumer.getData().get(0));
        obj = new StubObject("str", 1, 20L, 10.0);
        Assert.assertTrue((boolean)consumer.test((Object)obj));
        consumer.accept((Object)obj);
        Assert.assertEquals((Object)20L, consumer.getData().get(1));
        obj = new StubObject("str", 1, null, 10.0);
        Assert.assertFalse((boolean)consumer.test((Object)obj));
        Assert.assertEquals((Object)10L, (Object)consumer.getMin());
        Assert.assertEquals((Object)20L, (Object)consumer.getMax());
    }

    @Test
    public void testWithPredicate() {
        IDataChartDescriptor<StubObject, ?> descriptor = this.fProvider.getDataDescriptor("Long");
        Predicate<@Nullable Number> predicate = d -> true;
        NumericalConsumer consumer = new NumericalConsumer((INumericalResolver)INumericalResolver.class.cast(descriptor.getResolver()), predicate);
        StubObject obj = new StubObject("str", 1, 10L, 10.0);
        Assert.assertTrue((boolean)consumer.test((Object)obj));
        consumer.accept((Object)obj);
        Assert.assertEquals((Object)10L, consumer.getData().get(0));
        obj = new StubObject("str", 1, null, 10.0);
        Assert.assertTrue((boolean)consumer.test((Object)obj));
        consumer.accept((Object)obj);
        Assert.assertEquals((Object)0L, consumer.getData().get(1));
    }
}

