/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.ui.swtbot.tests.perf;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfBenchmarkTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.perf.views.ViewsResponseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.Assert;
import org.junit.Test;

public class LttngUstResponseBenchmark
extends ViewsResponseTest {
    private static final @NonNull String FLAMECHART_VIEW_ID = "org.eclipse.linuxtools.tmf.ui.views.callstack";
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.ust.tracetype";

    protected void prepareWorkspace() {
        SWTBotUtils.switchToPerspective((String)"org.eclipse.linuxtools.tmf.ui.perspective");
    }

    protected void beforeRunningTest(ITmfTrace trace) {
        ArrayList<IAnalysisModule> modules = new ArrayList<IAnalysisModule>(3);
        modules.add(trace.getAnalysisModule("org.eclipse.linuxtools.lttng2.ust.analysis.callstack"));
        for (IAnalysisModule module : modules) {
            if (module == null) continue;
            module.schedule();
        }
        for (IAnalysisModule module : modules) {
            if (module == null) continue;
            Assert.assertTrue((boolean)module.waitForCompletion());
        }
    }

    @Test
    public void testWithCygProfile() throws SecurityException, IllegalArgumentException, IOException {
        this.runTestWithTrace(FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.CYG_PROFILE.getTraceURL())).getAbsolutePath(), TRACE_TYPE, Collections.singleton(FLAMECHART_VIEW_ID));
    }

    @Test
    public void testWithQmlScene() throws SecurityException, IllegalArgumentException {
        this.runTestWithTrace(CtfBenchmarkTrace.UST_QMLSCENE.getTracePath().toString(), TRACE_TYPE, Collections.singleton(FLAMECHART_VIEW_ID));
    }
}

