/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.ITeamRunnableContext;
import org.eclipse.team.internal.ui.actions.JobRunnableContext;
import org.eclipse.team.internal.ui.actions.ProgressDialogRunnableContext;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.IProgressConstants;

public abstract class TeamOperation
extends JobChangeAdapter
implements IRunnableWithProgress {
    private final IWorkbenchPart part;
    private final IRunnableContext context;

    protected TeamOperation(IWorkbenchPart part) {
        this(part, null);
    }

    protected TeamOperation(IRunnableContext context) {
        this(null, context);
    }

    protected TeamOperation(IWorkbenchPart part, IRunnableContext context) {
        this.part = part;
        this.context = context;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public final void run() throws InvocationTargetException, InterruptedException {
        if (this.shouldRun()) {
            this.getRunnableContext().run(this);
        }
    }

    protected boolean shouldRun() {
        return true;
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    protected boolean isPostponeAutobuild() {
        return true;
    }

    protected boolean canRunAsJob() {
        return false;
    }

    protected String getJobName() {
        return "";
    }

    protected IAction getGotoAction() {
        return null;
    }

    protected URL getOperationIcon() {
        return null;
    }

    protected boolean getKeepOperation() {
        return false;
    }

    public boolean isKeepOneProgressServiceEntry() {
        return false;
    }

    protected boolean isSameFamilyAs(TeamOperation operation) {
        return false;
    }

    public boolean belongsTo(Object family) {
        return false;
    }

    public boolean isUserInitiated() {
        return true;
    }

    protected Shell getShell() {
        Shell[] shell = new Shell[1];
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(() -> {
                Shell shell = Utils.getShell(this.getSite());
            });
        } else {
            shell[0] = Utils.getShell(this.getSite());
        }
        return shell[0];
    }

    private ITeamRunnableContext getRunnableContext() {
        if (this.context == null && this.canRunAsJob()) {
            TeamOperationJobContext context = new TeamOperationJobContext(this);
            context.setPostponeBuild(this.isPostponeAutobuild());
            context.setSchedulingRule(this.getSchedulingRule());
            return context;
        }
        ProgressDialogRunnableContext context = new ProgressDialogRunnableContext();
        context.setPostponeBuild(this.isPostponeAutobuild());
        context.setSchedulingRule(this.getSchedulingRule());
        if (this.context != null) {
            context.setRunnableContext(this.context);
        }
        return context;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPartSite site = null;
        if (this.part != null) {
            site = this.part.getSite();
        }
        return site;
    }

    private static class TeamOperationJobContext
    extends JobRunnableContext {
        private final TeamOperation operation;
        private IAction gotoAction;

        public TeamOperationJobContext(TeamOperation operation) {
            super(operation.getJobName(), (IJobChangeListener)operation, operation.getSite());
            this.operation = operation;
        }

        @Override
        protected void configureJob(Job job) {
            URL icon;
            super.configureJob(job);
            if (this.operation.isKeepOneProgressServiceEntry()) {
                job.setProperty(IProgressConstants.KEEPONE_PROPERTY, (Object)Boolean.TRUE);
            } else if (this.operation.getKeepOperation()) {
                job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
            }
            this.gotoAction = this.operation.getGotoAction();
            if (this.gotoAction != null) {
                job.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)this.gotoAction);
            }
            if ((icon = this.operation.getOperationIcon()) != null) {
                job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)icon);
            }
        }

        @Override
        protected boolean belongsTo(JobRunnableContext.IContextJob job, Object family) {
            JobRunnableContext.IContextJob otherJob;
            IRunnableWithProgress runnable;
            if (family instanceof JobRunnableContext.IContextJob && (runnable = (otherJob = (JobRunnableContext.IContextJob)family).getRunnable()) instanceof TeamOperation) {
                return this.operation.isSameFamilyAs((TeamOperation)runnable);
            }
            return this.operation.belongsTo(family);
        }

        @Override
        protected IStatus getCompletionStatus() {
            if (this.gotoAction != null) {
                return new Status(0, "org.eclipse.team.ui", 0, this.gotoAction.getText(), null);
            }
            return super.getCompletionStatus();
        }

        @Override
        protected boolean isUser() {
            return this.operation.isUserInitiated();
        }
    }
}

