/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public abstract class HTNode {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(HTNode.class);
    private static final int COMMON_HEADER_SIZE = 37;
    private final HTConfig fConfig;
    private final long fNodeStart;
    private long fNodeEnd;
    private int fMinQuark = Integer.MAX_VALUE;
    private int fMaxQuark = Integer.MIN_VALUE;
    private final int fSequenceNumber;
    private int fParentSequenceNumber;
    private int fSizeOfIntervalSection;
    private volatile boolean fIsOnDisk;
    private final List<HTInterval> fIntervals;
    private final ReentrantReadWriteLock fRwl = new ReentrantReadWriteLock(false);
    private static final Comparator<ITmfStateInterval> NODE_ORDER = Comparator.comparingLong(ITmfStateInterval::getEndTime).thenComparingLong(ITmfStateInterval::getStartTime).thenComparingInt(ITmfStateInterval::getAttribute);

    protected HTNode(HTConfig config, int seqNumber, int parentSeqNumber, long start) {
        this.fConfig = config;
        this.fNodeStart = start;
        this.fNodeEnd = start;
        this.fSequenceNumber = seqNumber;
        this.fParentSequenceNumber = parentSeqNumber;
        this.fSizeOfIntervalSection = 0;
        this.fIsOnDisk = false;
        this.fIntervals = new ArrayList<HTInterval>();
    }

    public static final @NonNull HTNode readNode(HTConfig config, FileChannel channel, IHistoryTree.IHTNodeFactory nodeFactory) throws IOException {
        ByteBuffer buffer = HTNode.allocateNode(config);
        int res = channel.read(buffer);
        if (res != config.getBlockSize()) {
            throw new IOException("Expected " + config.getBlockSize() + " block size, but got " + res);
        }
        buffer.flip();
        return HTNode.parseNode(config, buffer, nodeFactory);
    }

    /*
     * Unable to fully structure code
     */
    public final void writeSelf(FileChannel channel) throws IOException {
        this.fRwl.readLock().lock();
        try {
            blockSize = this.fConfig.getBlockSize();
            buffer = HTNode.allocateNode(this.fConfig);
            buffer.put(this.getNodeType().toByte());
            buffer.putLong(this.fNodeStart);
            buffer.putLong(this.fNodeEnd);
            buffer.putInt(this.fMinQuark);
            buffer.putInt(this.fMaxQuark);
            buffer.putInt(this.fSequenceNumber);
            buffer.putInt(this.fParentSequenceNumber);
            buffer.putInt(this.fIntervals.size());
            this.writeSpecificHeader(buffer);
            for (HTInterval interval : this.fIntervals) {
                interval.writeInterval(buffer, this.fNodeStart);
            }
            if (blockSize - buffer.position() == this.getNodeFreeSpace()) ** GOTO lbl29
            throw new IllegalStateException("Wrong free space: Actual: " + (blockSize - buffer.position()) + ", Expected: " + this.getNodeFreeSpace());
lbl-1000:
            // 1 sources

            {
                buffer.put((byte)0);
lbl29:
                // 2 sources

                ** while (buffer.position() < blockSize)
            }
lbl30:
            // 1 sources

            buffer.flip();
            res = channel.write(buffer);
            if (res != blockSize) {
                throw new IllegalStateException("Wrong size of block written: Actual: " + res + ", Expected: " + blockSize);
            }
        }
        finally {
            this.fRwl.readLock().unlock();
        }
        this.fIsOnDisk = true;
    }

    protected HTConfig getConfig() {
        return this.fConfig;
    }

    public long getNodeStart() {
        return this.fNodeStart;
    }

    public long getNodeEnd() {
        this.fRwl.readLock().lock();
        try {
            long l = this.fNodeEnd;
            return l;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public int getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public int getParentSequenceNumber() {
        return this.fParentSequenceNumber;
    }

    public void setParentSequenceNumber(int newParent) {
        this.fParentSequenceNumber = newParent;
    }

    public boolean isOnDisk() {
        return this.fIsOnDisk;
    }

    public void addInterval(HTInterval newInterval) {
        this.fRwl.writeLock().lock();
        try {
            int newSizeOnDisk = newInterval.getSizeOnDisk(this.fNodeStart);
            if (newSizeOnDisk > this.getNodeFreeSpace()) {
                throw new IllegalStateException("Insufficient disk space.");
            }
            int index = 0;
            if (this.fIntervals.isEmpty()) {
                index = 0;
            } else if (NODE_ORDER.compare(this.fIntervals.get(this.fIntervals.size() - 1), newInterval) <= 0) {
                index = this.fIntervals.size();
            } else {
                index = Collections.binarySearch(this.fIntervals, newInterval, NODE_ORDER);
                index = -index - 1;
            }
            newInterval.setSizeOnDisk(newSizeOnDisk);
            this.fIntervals.add(index, newInterval);
            this.fNodeEnd = Long.max(this.fNodeEnd, newInterval.getEndTime());
            this.fMinQuark = Integer.min(this.fMinQuark, newInterval.getAttribute());
            this.fMaxQuark = Integer.max(this.fMaxQuark, newInterval.getAttribute());
            this.fSizeOfIntervalSection += newInterval.getSizeOnDisk();
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    public void closeThisNode(long endtime) {
        this.fRwl.writeLock().lock();
        try {
            if (this.fNodeEnd > endtime) {
                throw new IllegalArgumentException("Closing end time should be greater than or equal to the end time of the intervals of this node");
            }
            this.fNodeEnd = endtime;
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    public void writeInfoFromNode(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException {
        this.fRwl.readLock().lock();
        try {
            int i = this.getStartIndexFor(t);
            while (i < this.fIntervals.size()) {
                ITmfStateInterval interval = this.fIntervals.get(i);
                if (t >= interval.getStartTime() && interval.getAttribute() < stateInfo.size()) {
                    stateInfo.set(interval.getAttribute(), interval);
                }
                ++i;
            }
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public HTInterval getRelevantInterval(int key, long t) throws TimeRangeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Iterable<@NonNull HTInterval> iterable2D(IntegerRangeCondition quarks, TimeRangeCondition times) {
        this.fRwl.readLock().lock();
        try {
            ArrayList<HTInterval> arrayList;
            block14: {
                Throwable throwable = null;
                Object var4_5 = null;
                LogUtils.ScopeLog log = new LogUtils.ScopeLog(LOGGER, Level.FINEST, "HTNode:query2D", new Object[]{"quarks", quarks, "times", times});
                try {
                    ArrayList<@NonNull HTInterval> intervals = new ArrayList<HTInterval>();
                    for (HTInterval interval : this.fIntervals.subList(this.getStartIndexFor(times.min()), this.fIntervals.size())) {
                        if (!quarks.test(interval.getAttribute()) || !times.intersects(interval.getStartTime(), interval.getEndTime())) continue;
                        intervals.add(interval);
                    }
                    arrayList = intervals;
                    if (log == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        if (log != null) {
                            log.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                log.close();
            }
            return arrayList;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    private int getStartIndexFor(long t) throws TimeRangeException {
        if (this.fIntervals.isEmpty()) {
            return 0;
        }
        HTInterval dummy = new HTInterval(Long.MIN_VALUE, t, 0, null);
        int index = Collections.binarySearch(this.fIntervals, dummy, NODE_ORDER);
        return index >= 0 ? index : -index - 1;
    }

    public final int getTotalHeaderSize() {
        return 37 + this.getSpecificHeaderSize();
    }

    private int getDataSectionEndOffset() {
        return this.getTotalHeaderSize() + this.fSizeOfIntervalSection;
    }

    public int getNodeFreeSpace() {
        this.fRwl.readLock().lock();
        try {
            int n = this.fConfig.getBlockSize() - this.getDataSectionEndOffset();
            return n;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public long getNodeUsagePercent() {
        this.fRwl.readLock().lock();
        try {
            int blockSize = this.fConfig.getBlockSize();
            float freePercent = (float)this.getNodeFreeSpace() / (float)(blockSize - this.getTotalHeaderSize()) * 100.0f;
            long l = (long)(100.0f - freePercent);
            return l;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public int getMinQuark() {
        this.fRwl.readLock().lock();
        try {
            int n = this.fMinQuark;
            return n;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public int getMaxQuark() {
        this.fRwl.readLock().lock();
        try {
            int n = this.fMaxQuark;
            return n;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public String toString() {
        return String.format("Node #%d, %s, %s, %d intervals (%d%% used), [%d - %s]", this.fSequenceNumber, this.fParentSequenceNumber == -1 ? "Root" : "Parent #" + this.fParentSequenceNumber, this.toStringSpecific(), this.fIntervals.size(), this.getNodeUsagePercent(), this.fNodeStart, this.fIsOnDisk || this.fNodeEnd != 0L ? Long.valueOf(this.fNodeEnd) : "...");
    }

    public void debugPrintIntervals(PrintWriter writer) {
        writer.println("Intervals for node #" + this.fSequenceNumber + ":");
        if (this.getNodeType() != NodeType.LEAF) {
            ParentNode thisNode = (ParentNode)this;
            writer.print("  " + thisNode.getNbChildren() + " children");
            if (thisNode.getNbChildren() >= 1) {
                writer.print(": [ " + thisNode.getChild(0));
                int i = 1;
                while (i < thisNode.getNbChildren()) {
                    writer.print(", " + thisNode.getChild(i));
                    ++i;
                }
                writer.print(']');
            }
            writer.print('\n');
        }
        writer.println("  Intervals contained:");
        int i = 0;
        while (i < this.fIntervals.size()) {
            writer.println(this.fIntervals.get(i).toString());
            ++i;
        }
        writer.println('\n');
    }

    public abstract NodeType getNodeType();

    protected abstract int getSpecificHeaderSize();

    protected abstract void readSpecificHeader(ByteBuffer var1);

    protected abstract void writeSpecificHeader(ByteBuffer var1);

    protected abstract String toStringSpecific();

    public static ByteBuffer allocateNode(HTConfig config) {
        ByteBuffer buffer = ByteBuffer.allocate(config.getBlockSize());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.clear();
        return buffer;
    }

    public static int readToBuffer(FileChannel channel, int seqNb, long blockSize, ByteBuffer buffer) throws IOException {
        Throwable throwable = null;
        Object var6_6 = null;
        try (LogUtils.ScopeLog readNode = new LogUtils.ScopeLog(LOGGER, Level.FINEST, "HTNode#readToBuffer", new Object[0]);){
            IHistoryTree.seekFCToNodePos(channel, blockSize, seqNb);
            return channel.read(buffer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static @NonNull HTNode parseNode(HTConfig config, ByteBuffer buffer, IHistoryTree.IHTNodeFactory nodeFactory) throws IOException {
        HTNode newNode = null;
        byte typeByte = buffer.get();
        NodeType type = NodeType.fromByte(typeByte);
        long start = buffer.getLong();
        long end = buffer.getLong();
        int min = buffer.getInt();
        int max = buffer.getInt();
        int seqNb = buffer.getInt();
        int parentSeqNb = buffer.getInt();
        int intervalCount = buffer.getInt();
        switch (type) {
            case CORE: {
                newNode = nodeFactory.createCoreNode(config, seqNb, parentSeqNb, start);
                newNode.readSpecificHeader(buffer);
                break;
            }
            case LEAF: {
                newNode = nodeFactory.createLeafNode(config, seqNb, parentSeqNb, start);
                newNode.readSpecificHeader(buffer);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        int i = 0;
        while (i < intervalCount) {
            HTInterval interval = HTInterval.readFrom(buffer, start);
            newNode.fIntervals.add(interval);
            newNode.fSizeOfIntervalSection += interval.getSizeOnDisk();
            ++i;
        }
        newNode.fNodeEnd = end;
        newNode.fMinQuark = min;
        newNode.fMaxQuark = max;
        newNode.fIsOnDisk = true;
        return newNode;
    }

    public static enum NodeType {
        CORE,
        LEAF;


        public static NodeType fromByte(byte rep) throws IOException {
            switch (rep) {
                case 1: {
                    return CORE;
                }
                case 2: {
                    return LEAF;
                }
            }
            throw new IOException();
        }

        public byte toByte() {
            switch (this) {
                case CORE: {
                    return 1;
                }
                case LEAF: {
                    return 2;
                }
            }
            throw new IllegalStateException();
        }
    }
}

