/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoAnalysisModule;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoLoadedBinaryFile;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UstDebugInfoBinaryAspect
implements ITmfEventAspect<BinaryCallsite> {
    public static final UstDebugInfoBinaryAspect INSTANCE = new UstDebugInfoBinaryAspect();
    private static final long CACHE_SIZE = 1000L;
    private static final Optional<BinaryCallsite> OPTIONAL_NULL = Objects.requireNonNull(Optional.empty());
    private static final LoadingCache<TraceBinarySymbol, Optional<BinaryCallsite>> BINARY_CALLSITE_CACHE = Objects.requireNonNull(CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<TraceBinarySymbol, Optional<BinaryCallsite>>(){

        public Optional<BinaryCallsite> load(TraceBinarySymbol symbolIp) {
            UstDebugInfoAnalysisModule module = (UstDebugInfoAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)symbolIp.fTrace, UstDebugInfoAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.debuginfo");
            if (module == null) {
                return OPTIONAL_NULL;
            }
            UstDebugInfoLoadedBinaryFile file = module.getMatchingFile(symbolIp.fTs, symbolIp.fPid, symbolIp.fIp);
            if (file == null) {
                return OPTIONAL_NULL;
            }
            String fullPath = new File(symbolIp.fTrace.getSymbolProviderConfig().getActualRootDirPath(), file.getFilePath()).toString();
            long offset = file.isPic() ? symbolIp.fIp - file.getBaseAddress() : symbolIp.fIp;
            return Objects.requireNonNull(Optional.of(new BinaryCallsite(fullPath, file.getBuildId(), offset, file.isPic(), file.getValidityStart(), file.getValidityEnd())));
        }
    }));

    private UstDebugInfoBinaryAspect() {
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_BinaryAspectName);
    }

    public String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_BinaryAspectHelpText);
    }

    public @Nullable BinaryCallsite resolve(ITmfEvent event) {
        if (!(event.getTrace() instanceof LttngUstTrace)) {
            return null;
        }
        LttngUstTrace trace = (LttngUstTrace)event.getTrace();
        ILttngUstEventLayout layout = trace.getEventLayout();
        ITmfEventField vpidField = event.getContent().getField(new String[]{layout.contextVpid()});
        ITmfEventField ipField = event.getContent().getField(new String[]{layout.contextIp()});
        if (ipField == null) {
            ipField = event.getContent().getField(new String[]{layout.fieldAddr()});
        }
        if (vpidField == null || ipField == null) {
            return null;
        }
        Long vpid = (Long)vpidField.getValue();
        Long ip = (Long)ipField.getValue();
        long ts = event.getTimestamp().toNanos();
        return UstDebugInfoBinaryAspect.getBinaryCallsite(trace, vpid.intValue(), ts, ip);
    }

    public static @Nullable BinaryCallsite getBinaryCallsite(LttngUstTrace trace, int pid, long ts, long ip) {
        TraceBinarySymbol traceBinarySymbol = new TraceBinarySymbol(trace, pid, ts, ip);
        Optional binaryCallsite = (Optional)BINARY_CALLSITE_CACHE.getUnchecked((Object)traceBinarySymbol);
        if (!binaryCallsite.isPresent()) {
            return null;
        }
        if (!((BinaryCallsite)binaryCallsite.get()).intersects(ts)) {
            BINARY_CALLSITE_CACHE.invalidate((Object)traceBinarySymbol);
            binaryCallsite = (Optional)BINARY_CALLSITE_CACHE.getUnchecked((Object)traceBinarySymbol);
        }
        return binaryCallsite.isPresent() ? (BinaryCallsite)binaryCallsite.get() : null;
    }

    public static void invalidateSymbolCache() {
        BINARY_CALLSITE_CACHE.invalidateAll();
    }

    private static final class TraceBinarySymbol {
        private LttngUstTrace fTrace;
        private int fPid;
        private long fTs;
        private long fIp;

        public TraceBinarySymbol(LttngUstTrace trace, int pid, long ts, long ip) {
            this.fTrace = trace;
            this.fPid = pid;
            this.fTs = ts;
            this.fIp = ip;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.fTrace, this.fPid, this.fIp});
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TraceBinarySymbol)) {
                return false;
            }
            TraceBinarySymbol other = (TraceBinarySymbol)obj;
            return Objects.equals((Object)this.fTrace, (Object)other.fTrace) && this.fPid == other.fPid && this.fIp == other.fIp;
        }
    }
}

