/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import javax.servlet.Servlet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.DataProviderService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.FilterService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.XmlManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.CORSFilter;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.DataProviderDescriptorSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.ExperimentSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.SeriesModelSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TraceSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.XYModelSerializer;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class WebApplication {
    private static final String CONTEXT_PATH = "/tsp/api";
    private static final String PATH_SPEC = "/*";
    public static final int TEST_PORT = 8378;
    private int fPort;
    private Server fServer;

    public WebApplication() {
        this(8080);
    }

    public WebApplication(int port) {
        this.fPort = port;
    }

    public void start() throws Exception {
        ServletContextHandler sch = new ServletContextHandler();
        sch.setContextPath(CONTEXT_PATH);
        ResourceConfig rc = new ResourceConfig();
        rc.register(TraceManagerService.class);
        rc.register(ExperimentManagerService.class);
        rc.register(DataProviderService.class);
        rc.register(FilterService.class);
        rc.register(XmlManagerService.class);
        rc.register(CORSFilter.class);
        rc.register((Object)WebApplication.registerCustomMappers());
        ServletContainer sc = new ServletContainer(rc);
        ServletHolder holder = new ServletHolder((Servlet)sc);
        sch.addServlet(holder, PATH_SPEC);
        this.fServer = new Server(this.fPort);
        this.fServer.setHandler((Handler)sch);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        if (!project.exists()) {
            project.create(null);
        }
        project.open(null);
        this.fServer.start();
        if (this.fPort != 8378) {
            this.fServer.join();
        }
    }

    private static JacksonJaxbJsonProvider registerCustomMappers() {
        ObjectMapper mapper = new ObjectMapper();
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(mapper);
        SimpleModule module = new SimpleModule();
        module.addSerializer(ITmfTrace.class, (JsonSerializer)new TraceSerializer());
        module.addSerializer(TmfExperiment.class, (JsonSerializer)new ExperimentSerializer());
        module.addSerializer(DataProviderDescriptor.class, (JsonSerializer)new DataProviderDescriptorSerializer());
        module.addSerializer(ITmfXyModel.class, (JsonSerializer)new XYModelSerializer());
        module.addSerializer(ISeriesModel.class, (JsonSerializer)new SeriesModelSerializer());
        mapper.registerModule((Module)module);
        return provider;
    }

    public void stop() {
        try {
            this.fServer.stop();
            ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME).close(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

