/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsInterruptContext;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsSystemModel;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class TraceEventHandlerExecutionGraph
extends BaseHandler {
    private static final int IRQ_TIMER = 0;
    private static final NullProgressMonitor DEFAULT_PROGRESS_MONITOR = new NullProgressMonitor();
    private final Table<String, Integer, OsWorker> fKernel = HashBasedTable.create();
    private final IMatchProcessingUnit fMatchProcessing;
    private Map<TmfEventDependency.DependencyEvent, TmfVertex> fTcpNodes = new HashMap<TmfEventDependency.DependencyEvent, TmfVertex>();
    private TmfEventMatching fTcpMatching;

    public TraceEventHandlerExecutionGraph(OsExecutionGraphProvider provider, int priority) {
        super(provider, priority);
        this.fMatchProcessing = new IMatchProcessingUnit(){

            public void matchingEnded() {
            }

            public int countMatches() {
                return 0;
            }

            public void addMatch(@Nullable TmfEventDependency match) {
                if (match == null) {
                    return;
                }
                TmfVertex output = (TmfVertex)TraceEventHandlerExecutionGraph.this.fTcpNodes.remove(match.getSource());
                TmfVertex input = (TmfVertex)TraceEventHandlerExecutionGraph.this.fTcpNodes.remove(match.getDestination());
                if (output != null && input != null) {
                    output.linkVertical(input).setType(TmfEdge.EdgeType.NETWORK);
                }
            }

            public void init(Collection<ITmfTrace> fTraces) {
            }
        };
        ITmfTrace trace = provider.getTrace();
        this.fTcpMatching = new TmfEventMatching(Collections.singleton(trace), this.fMatchProcessing);
        this.fTcpMatching.initMatching();
    }

    private OsWorker getOrCreateKernelWorker(ITmfEvent event, Integer cpu) {
        String host = event.getTrace().getHostId();
        OsWorker worker = (OsWorker)this.fKernel.get((Object)host, (Object)cpu);
        if (worker == null) {
            HostThread ht = new HostThread(host, Integer.valueOf(-1));
            worker = new OsWorker(ht, "kernel/" + cpu, event.getTimestamp().getValue());
            worker.setStatus(ProcessStatus.RUN);
            this.fKernel.put((Object)host, (Object)cpu, (Object)worker);
        }
        return worker;
    }

    @Override
    public void handleEvent(ITmfEvent ev) {
        IKernelAnalysisEventLayout eventLayout;
        String eventName = ev.getName();
        if (eventName.equals((eventLayout = this.getProvider().getEventLayout(ev.getTrace())).eventSchedSwitch())) {
            this.handleSchedSwitch(ev);
        } else if (eventName.equals(eventLayout.eventSoftIrqEntry())) {
            this.handleSoftirqEntry(ev);
        } else if (eventLayout.eventsNetworkReceive().contains(eventName) || eventName.equals("inet_sock_local_in")) {
            this.handleInetSockLocalIn(ev);
        } else if (eventLayout.eventsNetworkSend().contains(eventName) || eventName.equals("inet_sock_local_out")) {
            this.handleInetSockLocalOut(ev);
        } else if (this.isWakeupEvent(ev)) {
            this.handleSchedWakeup(ev);
        }
    }

    private TmfVertex stateExtend(OsWorker task, long ts) {
        TmfGraph graph = (TmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getAssignedGraph());
        TmfVertex node = new TmfVertex(ts);
        ProcessStatus status = task.getStatus();
        graph.append((IGraphWorker)task, node, TraceEventHandlerExecutionGraph.resolveProcessStatus(status));
        return node;
    }

    private TmfVertex stateChange(OsWorker task, long ts) {
        TmfGraph graph = (TmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getAssignedGraph());
        TmfVertex node = new TmfVertex(ts);
        ProcessStatus status = task.getOldStatus();
        graph.append((IGraphWorker)task, node, TraceEventHandlerExecutionGraph.resolveProcessStatus(status));
        return node;
    }

    private static TmfEdge.EdgeType resolveProcessStatus(ProcessStatus status) {
        TmfEdge.EdgeType ret = TmfEdge.EdgeType.UNKNOWN;
        switch (status) {
            case NOT_ALIVE: {
                break;
            }
            case EXIT: 
            case RUN: 
            case RUN_SYTEMCALL: 
            case INTERRUPTED: {
                ret = TmfEdge.EdgeType.RUNNING;
                break;
            }
            case UNKNOWN: {
                ret = TmfEdge.EdgeType.UNKNOWN;
                break;
            }
            case WAIT_BLOCKED: {
                ret = TmfEdge.EdgeType.BLOCKED;
                break;
            }
            case WAIT_FORK: 
            case WAIT_CPU: 
            case WAIT_UNKNOWN: {
                ret = TmfEdge.EdgeType.PREEMPTED;
                break;
            }
            case ZOMBIE: {
                ret = TmfEdge.EdgeType.UNKNOWN;
                break;
            }
        }
        return ret;
    }

    private void handleSchedSwitch(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        long ts = event.getTimestamp().getValue();
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        ITmfEventField content = event.getContent();
        Integer next = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldNextTid()});
        Integer prev = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldPrevTid()});
        if (next == null || prev == null) {
            return;
        }
        OsWorker nextTask = system.findWorker(new HostThread(host, next));
        OsWorker prevTask = system.findWorker(new HostThread(host, prev));
        if (prevTask == null || nextTask == null) {
            return;
        }
        this.stateChange(prevTask, ts);
        this.stateChange(nextTask, ts);
    }

    private void handleSchedWakeup(ITmfEvent event) {
        TmfGraph graph = (TmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getAssignedGraph());
        String host = event.getTrace().getHostId();
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        long ts = event.getTimestamp().getValue();
        Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{eventLayout.fieldTid()});
        if (tid == null) {
            return;
        }
        OsWorker target = system.findWorker(new HostThread(host, tid));
        OsWorker current = system.getWorkerOnCpu(host, cpu);
        if (target == null) {
            return;
        }
        ProcessStatus status = target.getOldStatus();
        switch (status) {
            case WAIT_FORK: {
                this.waitFork(graph, ts, target, current);
                break;
            }
            case WAIT_BLOCKED: {
                this.waitBlocked(event, graph, host, cpu, eventLayout, system, ts, target, current);
                break;
            }
        }
    }

    private void waitBlocked(ITmfEvent event, TmfGraph graph, String host, Integer cpu, IKernelAnalysisEventLayout eventLayout, OsSystemModel system, long ts, OsWorker target, @Nullable OsWorker current) {
        OsInterruptContext context = system.peekContextStack(host, cpu);
        switch (context.getContext()) {
            case HRTIMER: {
                graph.append((IGraphWorker)target, new TmfVertex(ts), TmfEdge.EdgeType.TIMER);
                break;
            }
            case IRQ: 
            case COMPLETE_IRQ: {
                TraceEventHandlerExecutionGraph.irq(graph, eventLayout, ts, target, context);
                break;
            }
            case SOFTIRQ: {
                this.softIrq(event, graph, cpu, eventLayout, ts, target, context);
                break;
            }
            case IPI: {
                graph.append((IGraphWorker)target, new TmfVertex(ts), TmfEdge.EdgeType.IPI);
                break;
            }
            case NONE: {
                this.none(ts, target, current);
                break;
            }
            case PACKET_RECEPTION: {
                this.receivingFromNetwork(event, host, cpu, system, graph, ts, target, current);
                break;
            }
        }
    }

    private void receivingFromNetwork(ITmfEvent event, String host, Integer cpu, OsSystemModel system, TmfGraph graph, long ts, OsWorker target, @Nullable OsWorker current) {
        TmfVertex wupTarget;
        TmfEdge netLink;
        OsExecutionGraphProvider.Context innerCtx = TraceEventHandlerExecutionGraph.peekInnerContext(host, cpu, system);
        OsWorker source = current;
        if (innerCtx == OsExecutionGraphProvider.Context.SOFTIRQ || innerCtx == OsExecutionGraphProvider.Context.IRQ) {
            source = this.getOrCreateKernelWorker(event, cpu);
        }
        if ((netLink = graph.append((IGraphWorker)target, wupTarget = new TmfVertex(ts))) != null) {
            if (source != null && innerCtx != OsExecutionGraphProvider.Context.SOFTIRQ && innerCtx != OsExecutionGraphProvider.Context.IRQ) {
                netLink.setType(TmfEdge.EdgeType.NETWORK, source.getName());
            } else {
                netLink.setType(TmfEdge.EdgeType.NETWORK);
            }
        }
        if (source == null) {
            return;
        }
        TmfVertex tail = graph.getTail((IGraphWorker)source);
        if (tail != null) {
            TraceEventHandlerExecutionGraph.replaceIncomingNetworkEdge(tail, wupTarget);
        }
    }

    private static boolean replaceIncomingNetworkEdge(TmfVertex tail, TmfVertex wupTarget) {
        TmfEdge edge = tail.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
        if (edge == null || edge.getType() != TmfEdge.EdgeType.NETWORK) {
            return false;
        }
        TmfEdge newLink = edge.getVertexFrom().linkVertical(wupTarget);
        newLink.setType(TmfEdge.EdgeType.NETWORK);
        tail.removeEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
        return true;
    }

    private void extendAndLink(OsWorker worker, long ts, TmfVertex targetVertex) {
        TmfVertex wupSource = this.stateExtend(worker, ts);
        wupSource.linkVertical(targetVertex);
    }

    private void softIrq(ITmfEvent event, TmfGraph graph, Integer cpu, IKernelAnalysisEventLayout eventLayout, long ts, OsWorker target, OsInterruptContext context) {
        OsWorker k;
        TmfVertex tail;
        TmfVertex wupTarget = new TmfVertex(ts);
        TmfEdge hLink = graph.append((IGraphWorker)target, wupTarget);
        ITmfEventField content = context.getEvent().getContent();
        Long vec = (Long)content.getFieldValue(Long.class, new String[]{eventLayout.fieldVec()});
        if (hLink != null) {
            hLink.setType(TraceEventHandlerExecutionGraph.resolveSoftirq(vec));
        }
        if (vec != null && (vec == 3L || vec == 2L) && (tail = graph.getTail((IGraphWorker)(k = this.getOrCreateKernelWorker(event, cpu)))) != null) {
            TraceEventHandlerExecutionGraph.replaceIncomingNetworkEdge(tail, wupTarget);
        }
    }

    private void none(long ts, OsWorker target, @Nullable OsWorker current) {
        if (current != null) {
            TmfVertex n1 = this.stateChange(target, ts);
            this.extendAndLink(current, ts, n1);
        } else {
            this.stateChange(target, ts);
        }
    }

    private static void irq(TmfGraph graph, IKernelAnalysisEventLayout eventLayout, long ts, OsWorker target, OsInterruptContext context) {
        TmfVertex wup = new TmfVertex(ts);
        TmfEdge link = graph.append((IGraphWorker)target, wup);
        if (link != null) {
            ITmfEventField content = context.getEvent().getContent();
            Integer vec = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldIrq()});
            TmfEdge.EdgeType edgeType = TraceEventHandlerExecutionGraph.resolveIRQ(vec);
            if (edgeType.equals((Object)TmfEdge.EdgeType.BLOCKED)) {
                String irqName = (String)content.getFieldValue(String.class, new String[]{eventLayout.fieldName()});
                link.setType(edgeType, irqName);
            } else {
                link.setType(edgeType);
            }
        }
    }

    private void waitFork(TmfGraph graph, long ts, OsWorker target, @Nullable OsWorker current) {
        if (current != null) {
            TmfVertex n0 = this.stateExtend(current, ts);
            TmfVertex n1 = this.stateChange(target, ts);
            graph.link(n0, n1);
        } else {
            this.stateChange(target, ts);
        }
    }

    private static TmfEdge.EdgeType resolveIRQ(@Nullable Integer vec) {
        TmfEdge.EdgeType ret = TmfEdge.EdgeType.UNKNOWN;
        if (vec == null) {
            return ret;
        }
        switch (vec) {
            case 0: {
                ret = TmfEdge.EdgeType.INTERRUPTED;
                break;
            }
            default: {
                ret = TmfEdge.EdgeType.BLOCKED;
            }
        }
        return ret;
    }

    private static TmfEdge.EdgeType resolveSoftirq(@Nullable Long vec) {
        TmfEdge.EdgeType ret = TmfEdge.EdgeType.UNKNOWN;
        if (vec == null) {
            return ret;
        }
        switch (vec.intValue()) {
            case 1: 
            case 8: {
                ret = TmfEdge.EdgeType.TIMER;
                break;
            }
            case 4: 
            case 5: {
                ret = TmfEdge.EdgeType.BLOCK_DEVICE;
                break;
            }
            case 2: 
            case 3: {
                ret = TmfEdge.EdgeType.NETWORK;
                break;
            }
            case 7: {
                ret = TmfEdge.EdgeType.INTERRUPTED;
                break;
            }
            default: {
                ret = TmfEdge.EdgeType.BLOCKED;
            }
        }
        return ret;
    }

    private static OsExecutionGraphProvider.Context peekInnerContext(String host, Integer cpu, OsSystemModel system) {
        OsInterruptContext lastCtx = system.popContextStack(host, cpu);
        OsInterruptContext innerCtx = system.peekContextStack(host, cpu);
        if (lastCtx != null) {
            system.pushContextStack(host, cpu, lastCtx);
        }
        return innerCtx.getContext();
    }

    private void handleInetSockLocalIn(ITmfEvent event) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        String host = event.getTrace().getHostId();
        OsSystemModel system = this.getProvider().getSystem();
        OsInterruptContext intCtx = system.peekContextStack(host, cpu);
        OsExecutionGraphProvider.Context context = intCtx.getContext();
        if (context == OsExecutionGraphProvider.Context.PACKET_RECEPTION) {
            context = TraceEventHandlerExecutionGraph.peekInnerContext(host, cpu, system);
        }
        OsWorker receiver = null;
        receiver = context == OsExecutionGraphProvider.Context.SOFTIRQ || context == OsExecutionGraphProvider.Context.IRQ ? this.getOrCreateKernelWorker(event, cpu) : system.getWorkerOnCpu(event.getTrace().getHostId(), cpu);
        if (receiver == null) {
            return;
        }
        TmfVertex endpoint = this.stateExtend(receiver, event.getTimestamp().getValue());
        this.fTcpNodes.put(new TmfEventDependency.DependencyEvent(event), endpoint);
        this.fTcpMatching.matchEvent(event, event.getTrace(), (IProgressMonitor)DEFAULT_PROGRESS_MONITOR);
    }

    private void handleInetSockLocalOut(ITmfEvent event) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        String host = event.getTrace().getHostId();
        OsSystemModel system = this.getProvider().getSystem();
        OsInterruptContext intCtx = system.peekContextStack(host, cpu);
        OsExecutionGraphProvider.Context context = intCtx.getContext();
        if (context == OsExecutionGraphProvider.Context.PACKET_RECEPTION) {
            context = TraceEventHandlerExecutionGraph.peekInnerContext(host, cpu, system);
        }
        OsWorker sender = null;
        if (context == OsExecutionGraphProvider.Context.NONE) {
            sender = system.getWorkerOnCpu(event.getTrace().getHostId(), cpu);
        } else if (context == OsExecutionGraphProvider.Context.SOFTIRQ) {
            sender = this.getOrCreateKernelWorker(event, cpu);
        }
        if (sender == null) {
            return;
        }
        TmfVertex endpoint = this.stateExtend(sender, event.getTimestamp().getValue());
        this.fTcpNodes.put(new TmfEventDependency.DependencyEvent(event), endpoint);
        this.fTcpMatching.matchEvent(event, event.getTrace(), (IProgressMonitor)DEFAULT_PROGRESS_MONITOR);
    }

    private void handleSoftirqEntry(ITmfEvent event) {
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        TmfGraph graph = (TmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getAssignedGraph());
        Long vec = (Long)event.getContent().getFieldValue(Long.class, new String[]{eventLayout.fieldVec()});
        if (vec != null && (vec == 3L || vec == 2L)) {
            Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
            OsWorker k = this.getOrCreateKernelWorker(event, cpu);
            graph.add((IGraphWorker)k, new TmfVertex(event.getTimestamp().getValue()));
        }
    }
}

