/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.module;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlTimeGraphDataProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlTimeGraphEntryModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlXYDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.TmfTimeGraphCompositeDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.w3c.dom.Element;

@Deprecated
public class XmlDataProviderManager {
    private static @Nullable XmlDataProviderManager INSTANCE;
    private static final String ID_ATTRIBUTE = "id";
    private final Table<ITmfTrace, String, ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel>> fXyProviders = HashBasedTable.create();
    private final Table<ITmfTrace, String, ITimeGraphDataProvider<@NonNull XmlTimeGraphEntryModel>> fTimeGraphProviders = HashBasedTable.create();

    public static synchronized XmlDataProviderManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new XmlDataProviderManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        XmlDataProviderManager manager = INSTANCE;
        if (manager != null) {
            TmfSignalManager.deregister((Object)manager);
            manager.fXyProviders.clear();
            manager.fTimeGraphProviders.clear();
        }
        INSTANCE = null;
    }

    private XmlDataProviderManager() {
        TmfSignalManager.register((Object)this);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> getXyProvider(@NonNull ITmfTrace trace, @NonNull Element viewElement) {
        if (!viewElement.hasAttribute(ID_ATTRIBUTE)) {
            return null;
        }
        String viewId = viewElement.getAttribute(ID_ATTRIBUTE);
        @NonNull XmlXYDataProvider provider = (XmlXYDataProvider)((Object)this.fXyProviders.get((Object)trace, (Object)viewId));
        if (provider != null) {
            return provider;
        }
        if (Iterables.any((Iterable)TmfTraceManager.getInstance().getOpenedTraces(), opened -> TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)opened).contains(trace))) {
            Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
            if (traces.size() == 1) {
                Set<@NonNull String> analysisIds = TmfXmlUtils.getViewAnalysisIds(viewElement);
                Element entry = TmfXmlUtils.getChildElements(viewElement, "entry").get(0);
                provider = XmlXYDataProvider.create(trace, analysisIds, entry);
            } else {
                provider = this.generateExperimentProviderXy(traces, viewElement);
            }
            if (provider != null) {
                this.fXyProviders.put((Object)trace, (Object)viewId, provider);
            }
            return provider;
        }
        return null;
    }

    private ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> generateExperimentProviderXy(Collection<@NonNull ITmfTrace> traces, @NonNull Element viewElement) {
        ArrayList<@NonNull ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel>> providers = new ArrayList<ITmfTreeXYDataProvider<ITmfTreeDataModel>>();
        for (ITmfTrace child : traces) {
            ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> childProvider = this.getXyProvider(child, viewElement);
            if (childProvider == null) continue;
            providers.add(childProvider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeXYDataProvider)providers.get(0);
        }
        return new TmfTreeXYCompositeDataProvider(providers, "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider", "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized @Nullable ITimeGraphDataProvider<@NonNull XmlTimeGraphEntryModel> getTimeGraphProvider(@NonNull ITmfTrace trace, @NonNull Element viewElement) {
        if (!viewElement.hasAttribute(ID_ATTRIBUTE)) {
            return null;
        }
        String viewId = viewElement.getAttribute(ID_ATTRIBUTE);
        @NonNull XmlTimeGraphDataProvider provider = (XmlTimeGraphDataProvider)((Object)this.fTimeGraphProviders.get((Object)trace, (Object)viewId));
        if (provider != null) {
            return provider;
        }
        if (Iterables.any((Iterable)TmfTraceManager.getInstance().getOpenedTraces(), opened -> TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)opened).contains(trace))) {
            Collection traces;
            provider = XmlTimeGraphDataProvider.create(trace, viewElement);
            if (provider == null && (traces = TmfTraceManager.getTraceSet((ITmfTrace)trace)).size() > 1) {
                provider = this.generateExperimentProviderTimeGraph(traces, viewElement);
            }
            if (provider != null) {
                this.fTimeGraphProviders.put((Object)trace, (Object)viewId, (Object)provider);
            }
            return provider;
        }
        return null;
    }

    private @Nullable ITimeGraphDataProvider<@NonNull XmlTimeGraphEntryModel> generateExperimentProviderTimeGraph(Collection<@NonNull ITmfTrace> traces, @NonNull Element viewElement) {
        ArrayList<@NonNull ITimeGraphDataProvider<@NonNull XmlTimeGraphEntryModel>> providers = new ArrayList<ITimeGraphDataProvider<XmlTimeGraphEntryModel>>();
        for (ITmfTrace child : traces) {
            ITimeGraphDataProvider<@NonNull XmlTimeGraphEntryModel> childProvider = this.getTimeGraphProvider(child, viewElement);
            if (childProvider == null) continue;
            providers.add(childProvider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITimeGraphDataProvider)providers.get(0);
        }
        return new TmfTimeGraphCompositeDataProvider(providers, "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlTimeGraphDataProvider");
    }

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal signal) {
        for (ITmfTrace trace : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)signal.getTrace())) {
            this.fXyProviders.row((Object)trace).clear();
            this.fTimeGraphProviders.row((Object)trace).clear();
        }
    }
}

