/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;

public final class TsdlUtils {
    private static final UnaryStringParser STRING_PARSER = UnaryStringParser.INSTANCE;

    private TsdlUtils() {
    }

    public static boolean isUnaryString(CommonTree node) {
        return node.getType() == 121;
    }

    public static boolean isAnyUnaryString(CommonTree node) {
        return TsdlUtils.isUnaryString(node) || node.getType() == 122;
    }

    public static boolean isUnaryInteger(CommonTree node) {
        return node.getType() == 118 || node.getType() == 119 || node.getType() == 120;
    }

    public static @NonNull String concatenateUnaryStrings(List<CommonTree> strings) throws ParseException {
        StringBuilder sb = new StringBuilder();
        CommonTree first = strings.get(0);
        sb.append(STRING_PARSER.parse(first, null));
        boolean isFirst = true;
        for (CommonTree ref : strings) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            CommonTree id = (CommonTree)ref.getChild(0);
            if (ref.getType() == 5) {
                sb.append("->");
            } else {
                sb.append('.');
            }
            sb.append(STRING_PARSER.parse(id, null));
        }
        return sb.toString();
    }

    public static ParseException childTypeError(CommonTree child) {
        CommonTree parent = (CommonTree)child.getParent();
        String error = "Parent " + CTFParser.tokenNames[parent.getType()] + " can't have a child of type " + CTFParser.tokenNames[child.getType()] + ".";
        return new ParseException(error);
    }
}

